/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryResource;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ModelAnalyzer
extends ModelBase {
    private final ModelRenderer pedestal;
    private final ModelRenderer cover;
    private final ModelRenderer tower1;
    private final ModelRenderer tower2;
    private final ResourceLocation[] textures;

    public ModelAnalyzer(String gfxBase) {
        this.textures = new ResourceLocation[]{new ForestryResource(gfxBase + "pedestal.png"), new ForestryResource(gfxBase + "tower1.png"), new ForestryResource(gfxBase + "tower2.png")};
        this.pedestal = new ModelRenderer((ModelBase)this, 0, 0);
        this.pedestal.addBox(-8.0f, -8.0f, -8.0f, 16, 1, 16);
        this.pedestal.setRotationPoint(8.0f, 8.0f, 8.0f);
        this.cover = new ModelRenderer((ModelBase)this, 0, 0);
        this.cover.addBox(-8.0f, -8.0f, -8.0f, 16, 1, 16);
        this.cover.setRotationPoint(8.0f, 8.0f, 8.0f);
        this.tower1 = new ModelRenderer((ModelBase)this, 0, 0);
        this.tower1.addBox(-8.0f, -7.0f, -7.0f, 2, 14, 14);
        this.tower1.setRotationPoint(8.0f, 8.0f, 8.0f);
        this.tower2 = new ModelRenderer((ModelBase)this, 0, 0);
        this.tower2.addBox(6.0f, -7.0f, -7.0f, 2, 14, 14);
        this.tower2.setRotationPoint(8.0f, 8.0f, 8.0f);
    }

    public void render(ForgeDirection orientation, float posX, float posY, float posZ) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = 1.5707964f;
                break;
            }
            case WEST: {
                angle[1] = -1.5707964f;
                break;
            }
            case SOUTH: {
                break;
            }
            default: {
                angle[1] = (float)Math.PI;
            }
        }
        float factor = 0.0625f;
        Proxies.common.bindTexture(this.textures[0]);
        this.pedestal.rotateAngleX = angle[0];
        this.pedestal.rotateAngleY = angle[1];
        this.pedestal.rotateAngleZ = angle[2];
        this.pedestal.render(factor);
        this.cover.rotateAngleX = angle[0];
        this.cover.rotateAngleY = angle[1];
        this.cover.rotateAngleZ = (float)Math.PI;
        this.cover.render(factor);
        this.tower1.rotateAngleX = angle[0];
        this.tower1.rotateAngleY = angle[1];
        this.tower1.rotateAngleZ = angle[2];
        Proxies.common.bindTexture(this.textures[1]);
        this.tower1.render(factor);
        this.tower2.rotateAngleX = angle[0];
        this.tower2.rotateAngleY = angle[1];
        this.tower2.rotateAngleZ = angle[2];
        Proxies.common.bindTexture(this.textures[2]);
        this.tower2.render(factor);
        GL11.glPopMatrix();
    }
}

