/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.craftguide;

import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.config.ForestryBlock;
import forestry.factory.gadgets.MachineFabricator;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.LiquidSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;

public class CraftGuideFabricator
implements RecipeProvider {
    private final Slot[] slots = new Slot[12];

    public CraftGuideFabricator() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.slots[i + j * 3] = new ItemSlot(i * 18 + 3, j * 18 + 3, 16, 16).drawOwnBackground();
            }
        }
        this.slots[9] = new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground();
        this.slots[10] = new LiquidSlot(59, 39);
        this.slots[11] = new ItemSlot(59, 3, 16, 16).setSlotType(SlotType.MACHINE_SLOT);
    }

    public void generateRecipes(RecipeGenerator generator) {
        if (ForestryBlock.factoryTESR.block() == null) {
            return;
        }
        ItemStack machine = ForestryBlock.factoryPlain.getItemStack(1, 0);
        RecipeTemplate template = generator.createRecipeTemplate(this.slots, machine);
        for (IFabricatorRecipe recipe : MachineFabricator.RecipeManager.recipes) {
            Object[] array = new Object[12];
            Object[] recipeIngredients = recipe.getIngredients();
            if (recipeIngredients == null) continue;
            System.arraycopy(recipeIngredients, 0, array, 0, recipeIngredients.length);
            array[9] = recipe.getRecipeOutput();
            if (recipe.getLiquid() != null) {
                array[10] = recipe.getLiquid();
            }
            array[11] = machine;
            generator.addRecipe(template, array);
        }
    }
}

