/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.gadgets.Mill;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MillRainmaker
extends Mill {
    private int duration;
    private boolean reverse;

    public MillRainmaker() {
        this.speed = 0.01f;
        this.setInternalInventory(new InventoryRainmaker(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (!Proxies.common.isSimulating(player.worldObj)) {
            return;
        }
        if (player.inventory.getCurrentItem() == null) {
            return;
        }
        if (FuelManager.rainSubstrate.containsKey(player.inventory.getCurrentItem()) && this.charge == 0) {
            RainSubstrate substrate = FuelManager.rainSubstrate.get(player.inventory.getCurrentItem());
            if (substrate.item.isItemEqual(player.inventory.getCurrentItem())) {
                this.addCharge(substrate);
                --player.inventory.getCurrentItem().stackSize;
            }
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.charge = nbttagcompound.getInteger("Charge");
        this.progress = nbttagcompound.getFloat("Progress");
        this.stage = nbttagcompound.getInteger("Stage");
        this.duration = nbttagcompound.getInteger("Duration");
        this.reverse = nbttagcompound.getBoolean("Reverse");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("Charge", this.charge);
        nbttagcompound.setFloat("Progress", this.progress);
        nbttagcompound.setInteger("Stage", this.stage);
        nbttagcompound.setInteger("Duration", this.duration);
        nbttagcompound.setBoolean("Reverse", this.reverse);
    }

    private void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed;
        this.duration = substrate.duration;
        this.reverse = substrate.reverse;
    }

    @Override
    public void activate() {
        if (Proxies.render.hasRendering()) {
            this.worldObj.playSoundEffect((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, "ambient.weather.thunder", 4.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 0.7f);
            float f = (float)this.xCoord + 0.5f;
            float f1 = (float)this.yCoord + 0.0f + this.worldObj.rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.zCoord + 0.5f;
            float f3 = 0.52f;
            float f4 = this.worldObj.rand.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntityExplodeFX(this.worldObj, f - f3, f1, f2 + f4);
            Proxies.common.addEntityExplodeFX(this.worldObj, f + f3, f1, f2 + f4);
            Proxies.common.addEntityExplodeFX(this.worldObj, f + f4, f1, f2 - f3);
            Proxies.common.addEntityExplodeFX(this.worldObj, f + f4, f1, f2 + f3);
        }
        if (Proxies.common.isSimulating(this.worldObj)) {
            if (this.reverse) {
                this.worldObj.getWorldInfo().setRaining(false);
            } else {
                this.worldObj.getWorldInfo().setRaining(true);
                this.worldObj.getWorldInfo().setRainTime(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.sendNetworkUpdate();
        }
    }

    private static class InventoryRainmaker
    extends TileInventoryAdapter<MillRainmaker> {
        private static final int SLOT_SUBSTRATE = 0;

        public InventoryRainmaker(MillRainmaker tile) {
            super(tile, 1, "items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0 && FuelManager.rainSubstrate.containsKey(itemStack) && ((MillRainmaker)this.tile).charge == 0 && ((MillRainmaker)this.tile).progress == 0.0f) {
                RainSubstrate substrate = FuelManager.rainSubstrate.get(itemStack);
                if (((MillRainmaker)this.tile).worldObj.isRaining() && substrate.reverse) {
                    return true;
                }
                if (!((MillRainmaker)this.tile).worldObj.isRaining() && !substrate.reverse) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                RainSubstrate substrate = FuelManager.rainSubstrate.get(itemStack);
                if (substrate.item.isItemEqual(itemStack)) {
                    ((MillRainmaker)this.tile).addCharge(substrate);
                    ((MillRainmaker)this.tile).sendNetworkUpdate();
                }
            }
        }
    }
}

