/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.CreativeTabForestry;
import forestry.core.GameMode;
import forestry.core.PickupHandlerCore;
import forestry.core.SaveEventHandlerCore;
import forestry.core.circuits.CircuitRegistry;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.circuits.ItemSolderingIron;
import forestry.core.commands.CommandPlugins;
import forestry.core.commands.CommandVersion;
import forestry.core.commands.RootCommand;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.BlockResource;
import forestry.core.gadgets.BlockResourceStorageBlock;
import forestry.core.gadgets.BlockSoil;
import forestry.core.gadgets.BlockStainedGlass;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileEscritoire;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.ItemResearchNote;
import forestry.core.genetics.alleles.Allele;
import forestry.core.genetics.alleles.AlleleFactory;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.AlleleRegistry;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemArmorNaturalist;
import forestry.core.items.ItemAssemblyKit;
import forestry.core.items.ItemElectronTube;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemForestryPickaxe;
import forestry.core.items.ItemForestryShovel;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemMisc;
import forestry.core.items.ItemOverlay;
import forestry.core.items.ItemPipette;
import forestry.core.items.ItemTypedBlock;
import forestry.core.items.ItemWrench;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryModEnvWarningCallable;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

@Plugin(pluginID="Core", name="Core", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.core.description")
public class PluginCore
extends ForestryPlugin {
    private static MachineDefinition definitionEscritoire;
    public static final RootCommand rootCommand;
    private AlleleHelper alleleHelper;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        ChipsetManager.solderManager = new ItemSolderingIron.SolderManager();
        ChipsetManager.circuitRegistry = new CircuitRegistry();
        AlleleRegistry alleleRegistry = new AlleleRegistry();
        AlleleManager.alleleRegistry = alleleRegistry;
        AlleleManager.climateHelper = new ClimateHelper();
        AlleleManager.alleleFactory = new AlleleFactory();
        alleleRegistry.initialize();
    }

    @Override
    public void preInit() {
        super.preInit();
        rootCommand.addChildCommand(new CommandVersion());
        rootCommand.addChildCommand(new CommandPlugins());
        Allele.helper = this.alleleHelper = new AlleleHelper();
        ForestryBlock.core.registerBlock((Block)new BlockBase(Material.iron, true), ItemForestryBlock.class, "core");
        definitionEscritoire = ((BlockBase)ForestryBlock.core.block()).addDefinition(new MachineDefinition(1, "forestry.Escritoire", TileEscritoire.class, Proxies.render.getRenderEscritoire(), new IRecipe[0]));
        ForestryBlock.soil.registerBlock(new BlockSoil(), ItemTypedBlock.class, "soil");
        ForestryBlock.soil.block().setHarvestLevel("shovel", 0, 0);
        ForestryBlock.soil.block().setHarvestLevel("shovel", 0, 1);
        ForestryBlock.resources.registerBlock(new BlockResource(), ItemForestryBlock.class, "resources");
        ForestryBlock.resources.block().setHarvestLevel("pickaxe", 1);
        OreDictionary.registerOre((String)"oreApatite", (ItemStack)ForestryBlock.resources.getItemStack(1, 0));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)ForestryBlock.resources.getItemStack(1, 1));
        OreDictionary.registerOre((String)"oreTin", (ItemStack)ForestryBlock.resources.getItemStack(1, 2));
        ForestryBlock.resourceStorage.registerBlock(new BlockResourceStorageBlock(), ItemForestryBlock.class, "resourceStorage");
        ForestryBlock.resourceStorage.block().setHarvestLevel("pickaxe", 0);
        OreDictionary.registerOre((String)"blockApatite", (ItemStack)ForestryBlock.resourceStorage.getItemStack(1, 0));
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)ForestryBlock.resourceStorage.getItemStack(1, 1));
        OreDictionary.registerOre((String)"blockTin", (ItemStack)ForestryBlock.resourceStorage.getItemStack(1, 2));
        OreDictionary.registerOre((String)"blockBronze", (ItemStack)ForestryBlock.resourceStorage.getItemStack(1, 3));
        ForestryBlock.glass.registerBlock((Block)new BlockStainedGlass(), ItemForestryBlock.class, "stained");
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionEscritoire.register();
        ForestryModEnvWarningCallable.register();
        this.alleleHelper.init();
        RecipeSorter.register((String)"forestry:shapedrecipecustom", ShapedRecipeCustom.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"before:minecraft:shaped");
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerCore();
    }

    @Override
    protected void registerItems() {
        ForestryItem.fertilizerBio.registerItem(new ItemForestry(), "fertilizerBio");
        ForestryItem.fertilizerCompound.registerItem(new ItemForestry().setBonemeal(), "fertilizerCompound");
        ForestryItem.apatite.registerItem(new ItemForestry(), "apatite");
        OreDictionary.registerOre((String)"gemApatite", (ItemStack)ForestryItem.apatite.getItemStack());
        ForestryItem.researchNote.registerItem(new ItemResearchNote(), "researchNote");
        ForestryItem.ingotCopper.registerItem(new ItemForestry(), "ingotCopper");
        ForestryItem.ingotTin.registerItem(new ItemForestry(), "ingotTin");
        ForestryItem.ingotBronze.registerItem(new ItemForestry(), "ingotBronze");
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ForestryItem.ingotCopper.getItemStack());
        OreDictionary.registerOre((String)"ingotTin", (ItemStack)ForestryItem.ingotTin.getItemStack());
        OreDictionary.registerOre((String)"ingotBronze", (ItemStack)ForestryItem.ingotBronze.getItemStack());
        ForestryItem.wrench.registerItem(new ItemWrench(), "wrench");
        ForestryItem.pipette.registerItem(new ItemPipette(), "pipette");
        ForestryItem.sturdyCasing.registerItem(new ItemForestry(), "sturdyMachine");
        ForestryItem.hardenedCasing.registerItem(new ItemForestry(), "hardenedMachine");
        ForestryItem.impregnatedCasing.registerItem(new ItemForestry(), "impregnatedCasing");
        ForestryItem.craftingMaterial.registerItem(new ItemMisc(), "craftingMaterial");
        ForestryItem.naturalistHat.registerItem((Item)new ItemArmorNaturalist(), "naturalistHelmet");
        ForestryItem.peat.registerItem(new ItemForestry(), "peat");
        OreDictionary.registerOre((String)"brickPeat", (ItemStack)ForestryItem.peat.getItemStack());
        ForestryItem.ash.registerItem(new ItemForestry(), "ash");
        OreDictionary.registerOre((String)"dustAsh", (ItemStack)ForestryItem.ash.getItemStack());
        Proxies.common.addSmelting(ForestryItem.peat.getItemStack(), ForestryItem.ash.getItemStack());
        ForestryItem.bituminousPeat.registerItem(new ItemForestry(), "bituminousPeat");
        ForestryItem.gearBronze.registerItem(new ItemForestry(), "gearBronze");
        OreDictionary.registerOre((String)"gearBronze", (ItemStack)ForestryItem.gearBronze.getItemStack());
        ForestryItem.gearCopper.registerItem(new ItemForestry(), "gearCopper");
        OreDictionary.registerOre((String)"gearCopper", (ItemStack)ForestryItem.gearCopper.getItemStack());
        ForestryItem.gearTin.registerItem(new ItemForestry(), "gearTin");
        OreDictionary.registerOre((String)"gearTin", (ItemStack)ForestryItem.gearTin.getItemStack());
        ForestryItem.circuitboards.registerItem(new ItemCircuitBoard(), "chipsets");
        ForestryItem.solderingIron.registerItem(new ItemSolderingIron(), "solderingIron");
        Color tubeCoverNormal = Color.WHITE;
        Color tubeCoverGold = new Color(16775294);
        Color tubeCoverEnder = new Color(2446945);
        ForestryItem.tubes.registerItem(new ItemElectronTube(CreativeTabForestry.tabForestry, new ItemOverlay.OverlayInfo("ex-0", tubeCoverNormal, new Color(14923662)), new ItemOverlay.OverlayInfo("ex-1", tubeCoverNormal, new Color(15137023)), new ItemOverlay.OverlayInfo("ex-2", tubeCoverNormal, new Color(14533238)), new ItemOverlay.OverlayInfo("ex-3", tubeCoverNormal, new Color(0xCCCCCC)), new ItemOverlay.OverlayInfo("ex-4", tubeCoverNormal, new Color(0xFFFF8B)), new ItemOverlay.OverlayInfo("ex-5", tubeCoverNormal, new Color(9237987)), new ItemOverlay.OverlayInfo("ex-6", tubeCoverNormal, new Color(8809408)), new ItemOverlay.OverlayInfo("ex-7", tubeCoverGold, new Color(14247424)), new ItemOverlay.OverlayInfo("ex-8", tubeCoverNormal, new Color(0x444444)), new ItemOverlay.OverlayInfo("ex-9", tubeCoverNormal, new Color(52289)), new ItemOverlay.OverlayInfo("ex-10", tubeCoverNormal, new Color(5741785)), new ItemOverlay.OverlayInfo("ex-11", tubeCoverNormal, new Color(1857478)), new ItemOverlay.OverlayInfo("ex-12", tubeCoverEnder, new Color(0x33ADAD))), "thermionicTubes");
        ForestryItem.carton.registerItem(new ItemForestry(), "carton");
        ForestryItem.stickImpregnated.registerItem(new ItemForestry(), "oakStick");
        ForestryItem.woodPulp.registerItem(new ItemForestry(), "woodPulp");
        OreDictionary.registerOre((String)"pulpWood", (ItemStack)ForestryItem.woodPulp.getItemStack());
        ForestryItem.brokenBronzePickaxe.registerItem(new ItemForestry(), "brokenBronzePickaxe");
        ForestryItem.brokenBronzeShovel.registerItem(new ItemForestry(), "brokenBronzeShovel");
        ForestryItem.bronzePickaxe.registerItem(new ItemForestryPickaxe(ForestryItem.brokenBronzePickaxe.getItemStack()), "bronzePickaxe");
        ForestryItem.bronzePickaxe.item().setHarvestLevel("pickaxe", 3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzePickaxe.item());
        ForestryItem.bronzeShovel.registerItem(new ItemForestryShovel(ForestryItem.brokenBronzeShovel.getItemStack()), "bronzeShovel");
        ForestryItem.bronzeShovel.item().setHarvestLevel("shovel", 3);
        MinecraftForge.EVENT_BUS.register((Object)ForestryItem.bronzeShovel.item());
        ForestryItem.kitShovel.registerItem(new ItemAssemblyKit(ForestryItem.bronzeShovel.getItemStack()), "kitShovel");
        ForestryItem.kitPickaxe.registerItem(new ItemAssemblyKit(ForestryItem.bronzePickaxe.getItemStack()), "kitPickaxe");
        ForestryItem.mouldyWheat.registerItem(new ItemForestry(), "mouldyWheat");
        ForestryItem.decayingWheat.registerItem(new ItemForestry(), "decayingWheat");
        ForestryItem.mulch.registerItem(new ItemForestry(), "mulch");
        ForestryItem.iodineCharge.registerItem(new ItemForestry(), "iodineCapsule");
        ForestryItem.phosphor.registerItem(new ItemForestry(), "phosphor");
        ForestryItem.beeswax.registerItem(new ItemForestry().setCreativeTab(Tabs.tabApiculture), "beeswax");
        OreDictionary.registerOre((String)"itemBeeswax", (ItemStack)ForestryItem.beeswax.getItemStack());
        ForestryItem.refractoryWax.registerItem(new ItemForestry(), "refractoryWax");
        ForestryItem.fruits.registerItem((Item)new ItemFruit(), "fruits");
    }

    @Override
    protected void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(new ItemStack(Blocks.log, 1, 0), "cratedWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.log, 1, 1), "cratedSpruceWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.log, 1, 2), "cratedBirchWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.log, 1, 3), "cratedJungleWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.log2, 1, 0), "cratedAcaciaWood");
        crateRegistry.registerCrate(new ItemStack(Blocks.log2, 1, 1), "cratedDarkOakWood");
        crateRegistry.registerCrate(Blocks.cobblestone, "cratedCobblestone");
        crateRegistry.registerCrate(new ItemStack(Blocks.dirt, 1, 0), "cratedDirt");
        crateRegistry.registerCrate(new ItemStack(Blocks.dirt, 1, 2), "cratedPodzol");
        crateRegistry.registerCrate(Blocks.stone, "cratedStone");
        crateRegistry.registerCrate(Blocks.brick_block, "cratedBrick");
        crateRegistry.registerCrate(Blocks.cactus, "cratedCacti");
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.sand, 1, 0), "cratedSand");
        crateRegistry.registerCrate(new ItemStack((Block)Blocks.sand, 1, 1), "cratedRedSand");
        crateRegistry.registerCrate(Blocks.obsidian, "cratedObsidian");
        crateRegistry.registerCrate(Blocks.netherrack, "cratedNetherrack");
        crateRegistry.registerCrate(Blocks.soul_sand, "cratedSoulsand");
        crateRegistry.registerCrate(Blocks.sandstone, "cratedSandstone");
        crateRegistry.registerCrate(ForestryBlock.soil.getItemStack(1, 0), "cratedHumus");
        crateRegistry.registerCrate(ForestryBlock.soil.getItemStack(1, 1), "cratedBogearth");
        crateRegistry.registerCrate(Blocks.nether_brick, "cratedNetherbrick");
        crateRegistry.registerCrate(ForestryItem.peat.item(), "cratedPeat");
        crateRegistry.registerCrate(ForestryItem.apatite.item(), "cratedApatite");
        crateRegistry.registerCrate(ForestryItem.fertilizerCompound.item(), "cratedFertilizer");
        crateRegistry.registerCrate(Items.wheat, "cratedWheat");
        crateRegistry.registerCrate((Block)Blocks.mycelium, "cratedMycelium");
        crateRegistry.registerCrate(ForestryItem.mulch.item(), "cratedMulch");
        crateRegistry.registerCrate(Items.cookie, "cratedCookies");
        crateRegistry.registerCrate(Items.redstone, "cratedRedstone");
        crateRegistry.registerCrate(new ItemStack(Items.dye, 1, 4), "cratedLapis");
        crateRegistry.registerCrate(Items.reeds, "cratedReeds");
        crateRegistry.registerCrate(Items.clay_ball, "cratedClay");
        crateRegistry.registerCrate(Items.glowstone_dust, "cratedGlowstone");
        crateRegistry.registerCrate(Items.apple, "cratedApples");
        crateRegistry.registerCrate(new ItemStack(Items.nether_wart), "cratedNetherwart");
        crateRegistry.registerCrate(ForestryItem.phosphor.item(), "cratedPhosphor");
        crateRegistry.registerCrate(ForestryItem.ash.item(), "cratedAsh");
        crateRegistry.registerCrate(new ItemStack(Items.coal, 1, 1), "cratedCharcoal");
        crateRegistry.registerCrate(new ItemStack(Items.coal, 1, 0), "cratedCoal");
        crateRegistry.registerCrate(Blocks.gravel, "cratedGravel");
        crateRegistry.registerCrate(Items.wheat_seeds, "cratedSeeds");
        crateRegistry.registerCrate(new ItemStack(Blocks.sapling, 1, 0), "cratedSaplings");
        crateRegistry.registerCrate(new ItemStack(Blocks.sapling, 1, 1), "cratedSpruceSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.sapling, 1, 2), "cratedBirchSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.sapling, 1, 3), "cratedJungleSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.sapling, 1, 4), "cratedAcaciaSapling");
        crateRegistry.registerCrate(new ItemStack(Blocks.sapling, 1, 5), "cratedDarkOakSapling");
        crateRegistry.registerCrate(Items.potato, "cratedPotatoes");
        crateRegistry.registerCrate(Items.carrot, "cratedCarrots");
        crateRegistry.registerCrateUsingOreDict(ForestryItem.ingotTin.item(), "cratedTin");
        crateRegistry.registerCrateUsingOreDict(ForestryItem.ingotCopper.item(), "cratedCopper");
        crateRegistry.registerCrateUsingOreDict(ForestryItem.ingotBronze.item(), "cratedBronze");
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addSmelting(ForestryBlock.resources.getItemStack(1, 0), ForestryItem.apatite.getItemStack(), 0.5f);
        Proxies.common.addSmelting(ForestryBlock.resources.getItemStack(1, 1), ForestryItem.ingotCopper.getItemStack(), 0.5f);
        Proxies.common.addSmelting(ForestryBlock.resources.getItemStack(1, 2), ForestryItem.ingotTin.getItemStack(), 0.5f);
        if (Config.isCraftingBronzeEnabled()) {
            Proxies.common.addShapelessRecipe(ForestryItem.ingotBronze.getItemStack(4), "ingotTin", "ingotCopper", "ingotCopper", "ingotCopper");
        }
        Proxies.common.addRecipe(ForestryItem.sturdyCasing.getItemStack(), "###", "# #", "###", Character.valueOf('#'), "ingotBronze");
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.can"), " # ", "# #", Character.valueOf('#'), "ingotTin");
        ArrayList stoneGear = OreDictionary.getOres((String)"gearStone");
        String gearCenter = !stoneGear.isEmpty() ? "gearStone" : "ingotCopper";
        Proxies.common.addRecipe(ForestryItem.gearBronze.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), gearCenter);
        Proxies.common.addRecipe(ForestryItem.gearCopper.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), gearCenter);
        Proxies.common.addRecipe(ForestryItem.gearTin.getItemStack(), " # ", "#X#", " # ", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), gearCenter);
        Proxies.common.addRecipe(ForestryItem.bronzePickaxe.getItemStack(), " X ", " X ", "###", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        Proxies.common.addRecipe(ForestryItem.bronzeShovel.getItemStack(), " X ", " X ", " # ", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), "stickWood");
        Proxies.common.addShapelessRecipe(ForestryItem.kitPickaxe.getItemStack(), new Object[]{ForestryItem.bronzePickaxe, ForestryItem.carton});
        Proxies.common.addShapelessRecipe(ForestryItem.kitShovel.getItemStack(), new Object[]{ForestryItem.bronzeShovel, ForestryItem.carton});
        Proxies.common.addRecipe(ForestryItem.naturalistHat.getItemStack(), " X ", "Y Y", Character.valueOf('X'), "ingotBronze", Character.valueOf('Y'), "paneGlass");
        Proxies.common.addRecipe(ForestryItem.wrench.getItemStack(), "# #", " # ", " # ", Character.valueOf('#'), "ingotBronze");
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.wheat").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.compost.wheat"), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), "cropWheat");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.compost.ash").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.compost.ash"), " X ", "X#X", " X ", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), "dustAsh");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.fertilizer.apatite").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.fertilizer.apatite"), " # ", " X ", " # ", Character.valueOf('#'), "sand", Character.valueOf('X'), "gemApatite");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.fertilizer.ash").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.fertilizer.ash"), "###", "#X#", "###", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), "gemApatite");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.humus.compost").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.humus.compost"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), ForestryItem.fertilizerBio});
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.humus.fertilizer").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.humus.fertilizer"), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), ForestryItem.fertilizerCompound});
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.bucket").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.bucket"), "#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), Items.water_bucket, Character.valueOf('Y'), "sand");
        }
        if (GameMode.getGameMode().getStackSetting((String)"recipe.output.bogearth.can").stackSize > 0) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), ForestryItem.canWater, Character.valueOf('Y'), "sand"});
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), ForestryItem.waxCapsuleWater, Character.valueOf('Y'), "sand"});
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.bogearth.can"), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), Blocks.dirt, Character.valueOf('X'), ForestryItem.refractoryWater, Character.valueOf('Y'), "sand"});
        }
        Proxies.common.addRecipe(new ItemStack(Items.string), "#", "#", "#", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 2));
        Proxies.common.addRecipe(ForestryItem.pipette.getItemStack(), "  #", " X ", "X  ", Character.valueOf('X'), Blocks.glass_pane, Character.valueOf('#'), new ItemStack(Blocks.wool, 1, Short.MAX_VALUE));
        Proxies.common.addRecipe(ForestryBlock.resourceStorage.getItemStack(1, 0), "###", "###", "###", Character.valueOf('#'), "gemApatite");
        Proxies.common.addShapelessRecipe(ForestryItem.apatite.getItemStack(9), "blockApatite");
        Proxies.common.addRecipe(ForestryBlock.resourceStorage.getItemStack(1, 1), "###", "###", "###", Character.valueOf('#'), "ingotCopper");
        Proxies.common.addShapelessRecipe(ForestryItem.ingotCopper.getItemStack(9), "blockCopper");
        Proxies.common.addRecipe(ForestryBlock.resourceStorage.getItemStack(1, 2), "###", "###", "###", Character.valueOf('#'), "ingotTin");
        Proxies.common.addShapelessRecipe(ForestryItem.ingotTin.getItemStack(9), "blockTin");
        Proxies.common.addRecipe(ForestryBlock.resourceStorage.getItemStack(1, 3), "###", "###", "###", Character.valueOf('#'), "ingotBronze");
        Proxies.common.addShapelessRecipe(ForestryItem.ingotBronze.getItemStack(9), "blockBronze");
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerCore();
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{rootCommand};
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    static {
        rootCommand = new RootCommand();
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            if (fuel != null && fuel.getItem() == ForestryItem.peat.item()) {
                return 2000;
            }
            if (fuel != null && fuel.getItem() == ForestryItem.bituminousPeat.item()) {
                return 4200;
            }
            return 0;
        }
    }
}

