/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network;

import forestry.core.interfaces.IActivatable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.tileentity.TileEntity;

public class PacketActiveUpdate
extends PacketCoordinates {
    private boolean active;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketActiveUpdate(data);
    }

    private PacketActiveUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketActiveUpdate(IActivatable tile) {
        super(PacketId.TILE_FORESTRY_ACTIVE, tile.getCoordinates());
        this.active = tile.isActive();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IActivatable) {
            ((IActivatable)tile).setActive(this.active);
        }
    }
}

