/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public abstract class ItemForestryTool
extends ItemForestry {
    private final ItemStack remnants;
    protected float efficiencyOnProperMaterial;
    private final List<Block> blocksEffectiveAgainst;

    protected ItemForestryTool(Block[] blocksEffectiveAgainst, ItemStack remnants) {
        this.blocksEffectiveAgainst = Arrays.asList(blocksEffectiveAgainst);
        this.maxStackSize = 1;
        this.efficiencyOnProperMaterial = 6.0f;
        this.setMaxDamage(200);
        this.remnants = remnants;
    }

    public float func_150893_a(ItemStack itemstack, Block block) {
        if (this.blocksEffectiveAgainst.contains(block)) {
            return this.efficiencyOnProperMaterial;
        }
        return 1.0f;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int md) {
        if (ForgeHooks.isToolEffective((ItemStack)itemstack, (Block)block, (int)md)) {
            return this.efficiencyOnProperMaterial;
        }
        return this.func_150893_a(itemstack, block);
    }

    @SubscribeEvent
    public void onDestroyCurrentItem(PlayerDestroyItemEvent event) {
        if (event.original == null || event.original.getItem() != this) {
            return;
        }
        if (Proxies.common.isSimulating(event.entityPlayer.worldObj) && this.remnants != null) {
            EntityItem entity = new EntityItem(event.entityPlayer.worldObj, event.entityPlayer.posX, event.entityPlayer.posY, event.entityPlayer.posZ, this.remnants.copy());
            event.entityPlayer.worldObj.spawnEntityInWorld((Entity)entity);
        }
    }

    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, int j, int k, int l, EntityLivingBase entityliving) {
        itemstack.damageItem(1, entityliving);
        return true;
    }

    public boolean isFull3D() {
        return true;
    }
}

