/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ISqueezerManager;
import forestry.core.EnumErrorCode;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISpeedUpgradable;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineSqueezer
extends TilePowered
implements ISocketable,
ISidedInventory,
ILiquidTankContainer,
ISpeedUpgradable {
    private static final int TICKS_PER_RECIPE_TIME = 4;
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final TankManager tankManager;
    private final FilteredTank productTank;
    private final SqueezerInventory inventory = new SqueezerInventory(this);
    private Recipe currentRecipe;

    public MachineSqueezer() {
        super(1100, 4000, 2000);
        this.setInternalInventory(this.inventory);
        this.setHints(Config.hints.get("squeezer"));
        this.productTank = new FilteredTank(10000, RecipeManager.recipeFluids);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.SqueezerGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.readFromNBT(nbttagcompound);
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.getStackInSlot(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        super.writeGuiData(data);
        this.sockets.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        super.readGuiData(data);
        this.sockets.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            this.inventory.fillContainers(this.productTank.getFluid(), this.tankManager);
        }
    }

    @Override
    public boolean workCycle() {
        EntityPlayer player = Proxies.common.getPlayer(this.worldObj, this.getAccessHandler().getOwner());
        if (!this.inventory.removeResources(this.currentRecipe.resources, player)) {
            return false;
        }
        FluidStack resultFluid = this.currentRecipe.liquid;
        this.productTank.fill(resultFluid, true);
        if (this.currentRecipe.remnants != null && this.worldObj.rand.nextInt(100) < this.currentRecipe.chance) {
            ItemStack remnant = this.currentRecipe.remnants.copy();
            this.inventory.addRemnant(remnant, true);
        }
        return true;
    }

    private boolean checkRecipe() {
        ItemStack[] resources = this.inventory.getResources();
        Recipe matchingRecipe = RecipeManager.findMatchingRecipe(resources);
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.timePerItem;
                this.setTicksPerWorkCycle(recipeTime * 4);
                this.setEnergyPerWorkCycle(recipeTime * 200);
            }
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasResources = this.inventory.hasResources();
        boolean hasRecipe = true;
        boolean canFill = true;
        boolean canAdd = true;
        if (hasResources) {
            boolean bl = hasRecipe = this.currentRecipe != null;
            if (hasRecipe) {
                FluidStack resultFluid = this.currentRecipe.liquid;
                boolean bl2 = canFill = this.productTank.fill(resultFluid, false) == resultFluid.amount;
                if (this.currentRecipe.remnants != null) {
                    canAdd = this.inventory.addRemnant(this.currentRecipe.remnants, false);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasResources, EnumErrorCode.NORESOURCE);
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NORECIPE);
        errorLogic.setCondition(!canFill, EnumErrorCode.NOSPACETANK);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NOSPACE);
        return hasResources && hasRecipe && canFill && canAdd;
    }

    public int getResourceScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void getGUINetworkData(int messageId, int data) {
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.getSizeInventory();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.getStackInSlot(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.getStackInSlot(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.getStackInSlot(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.getStackInSlot(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.setInventorySlotContents(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    public static class RecipeManager
    implements ISqueezerManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        public static final HashSet<Fluid> recipeFluids = new HashSet();
        public static final HashSet<ItemStack> recipeInputs = new HashSet();

        @Override
        public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid, ItemStack remnants, int chance) {
            recipes.add(new Recipe(timePerItem, resources, liquid, remnants, chance));
            if (liquid != null) {
                recipeFluids.add(liquid.getFluid());
            }
            if (resources != null) {
                recipeInputs.addAll(Arrays.asList(resources));
            }
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid) {
            this.addRecipe(timePerItem, resources, liquid, null, 0);
        }

        public static Recipe findMatchingRecipe(ItemStack[] items) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(items)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean canUse(ItemStack itemStack) {
            if (recipeInputs.contains(itemStack)) {
                return true;
            }
            for (ItemStack recipeInput : recipeInputs) {
                if (!StackUtils.isCraftingEquivalent(recipeInput, itemStack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.resources, new Object[]{recipe.remnants, recipe.liquid});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ItemStack[] resources;
        public final FluidStack liquid;
        public final ItemStack remnants;
        public final int chance;

        public Recipe(int timePerItem, ItemStack[] resources, FluidStack liquid, ItemStack remnants, int chance) {
            this.timePerItem = timePerItem;
            this.resources = resources;
            this.liquid = liquid;
            this.remnants = remnants;
            this.chance = chance;
        }

        public boolean matches(ItemStack[] res) {
            return StackUtils.containsSets(this.resources, res, true, false) > 0;
        }
    }

    public static class SqueezerInventory
    extends TileInventoryAdapter<MachineSqueezer> {
        public static final short SLOT_RESOURCE_1 = 0;
        public static final short SLOTS_RESOURCE_COUNT = 9;
        public static final short SLOT_REMNANT = 9;
        public static final short SLOT_REMNANT_COUNT = 1;
        public static final short SLOT_CAN_INPUT = 10;
        public static final short SLOT_CAN_OUTPUT = 11;

        public SqueezerInventory(MachineSqueezer squeezer) {
            super(squeezer, 12, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 10) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex >= 0 && slotIndex < 9) {
                if (FluidHelper.isEmptyContainer(itemStack)) {
                    return false;
                }
                if (RecipeManager.canUse(itemStack)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 9 || slotIndex == 11;
        }

        public boolean hasResources() {
            return !InvTools.isEmpty((IInventory)this, 0, 9);
        }

        public ItemStack[] getResources() {
            return InvTools.getStacks((IInventory)this, 0, 9);
        }

        public boolean removeResources(ItemStack[] stacks, EntityPlayer player) {
            return InvTools.removeSets((IInventory)this, 1, stacks, 0, 9, player, false, true);
        }

        public boolean addRemnant(ItemStack remnant, boolean doAdd) {
            return InvTools.tryAddStack((IInventory)this, remnant, 9, 1, true, doAdd);
        }

        public void fillContainers(FluidStack fluidStack, TankManager tankManager) {
            if (this.getStackInSlot(10) == null || fluidStack == null) {
                return;
            }
            FluidHelper.fillContainers(tankManager, (IInventory)this, 10, 11, fluidStack.getFluid());
        }
    }
}

