/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.INBTTagable;
import forestry.core.GameMode;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.farming.multiblock.FarmInventory;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class FarmFertilizerManager
implements INBTTagable,
IStreamable {
    private static final int BUFFER_FERTILIZER = 200;
    private final int fertilizerValue = GameMode.getGameMode().getIntegerSetting("farms.fertilizer.value");
    private int storedFertilizer;

    public boolean hasFertilizer(int amount) {
        if (this.fertilizerValue < 0) {
            return true;
        }
        return this.storedFertilizer >= amount;
    }

    public void removeFertilizer(int amount) {
        if (this.fertilizerValue < 0) {
            return;
        }
        this.storedFertilizer -= amount;
        if (this.storedFertilizer < 0) {
            this.storedFertilizer = 0;
        }
    }

    public boolean maintainFertilizer(FarmInventory inventory) {
        if (this.storedFertilizer <= 200) {
            if (this.fertilizerValue < 0) {
                this.storedFertilizer += 2000;
            } else if (inventory.useFertilizer()) {
                this.storedFertilizer += this.fertilizerValue;
            }
        }
        return this.storedFertilizer > 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.storedFertilizer = data.getInteger("StoredFertilizer");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.setInteger("StoredFertilizer", this.storedFertilizer);
    }

    public int getStoredFertilizerScaled(int scale) {
        if (this.storedFertilizer == 0) {
            return 0;
        }
        return this.storedFertilizer * scale / (this.fertilizerValue + 200);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.storedFertilizer);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.storedFertilizer = data.readVarInt();
    }
}

