/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.ForestryBlock;
import forestry.core.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableGE
implements IFarmable {
    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.isAirBlock(x, y, z)) {
            return false;
        }
        return ForestryBlock.saplingGE.isBlockEqual(world, x, y, z);
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (!block.isWood((IBlockAccess)world, x, y, z)) {
            return null;
        }
        return new CropBlock(world, block, world.getBlockMetadata(x, y, z), new Vect(x, y, z));
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return germling.copy().tryPlaceItemIntoWorld(player, world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        IAlleleTreeSpecies tree = TreeGenome.getSpecies(itemstack);
        return tree != null;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

