/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.genetics.IPollinatable;
import forestry.arboriculture.genetics.FakePollinatable;
import forestry.arboriculture.genetics.ICheckPollinatable;
import forestry.core.utils.GeneticsUtil;
import forestry.lepidopterology.entities.AIButterflyInteract;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.plugins.PluginLepidopterology;

public class AIButterflyPollinate
extends AIButterflyInteract {
    public AIButterflyPollinate(EntityButterfly entity) {
        super(entity);
    }

    @Override
    protected boolean canInteract() {
        if (this.entity.cooldownPollination > 0 || !PluginLepidopterology.isPollinationAllowed()) {
            return false;
        }
        ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(this.entity.worldObj, this.rest.posX, this.rest.posY, this.rest.posZ);
        if (checkPollinatable == null) {
            return false;
        }
        if (!this.entity.getButterfly().getGenome().getFlowerProvider().isAcceptedPollinatable(this.entity.worldObj, new FakePollinatable(checkPollinatable))) {
            return false;
        }
        return this.entity.getPollen() == null || checkPollinatable.canMateWith(this.entity.getPollen());
    }

    public void updateTask() {
        if (this.continueExecuting()) {
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(this.entity.worldObj, this.rest.posX, this.rest.posY, this.rest.posZ);
            if (checkPollinatable != null) {
                IPollinatable realPollinatable;
                if (this.entity.getPollen() == null) {
                    this.entity.setPollen(checkPollinatable.getPollen());
                } else if (checkPollinatable.canMateWith(this.entity.getPollen()) && (realPollinatable = GeneticsUtil.getOrCreatePollinatable(null, this.entity.worldObj, this.rest.posX, this.rest.posY, this.rest.posZ)) != null) {
                    realPollinatable.mateWith(this.entity.getPollen());
                    this.entity.setPollen(null);
                }
            }
            this.setHasInteracted();
            this.entity.cooldownPollination = 1500;
        }
    }
}

