/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.items.ItemForestryFood;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBeverage
extends ItemForestryFood {
    public final BeverageInfo[] beverages;

    public ItemBeverage(BeverageInfo ... beverages) {
        super(1, 0.2f);
        this.setMaxStackSize(1);
        this.beverages = beverages;
    }

    public boolean getShareTag() {
        return true;
    }

    public ItemStack onEaten(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        List<IBeverageEffect> effects = BeverageInfo.loadEffects(itemstack);
        --itemstack.stackSize;
        entityplayer.getFoodStats().func_151686_a((ItemFood)this, itemstack);
        world.playSoundAtEntity((Entity)entityplayer, "random.burp", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        for (IBeverageEffect effect : effects) {
            effect.doEffect(world, entityplayer);
        }
        return itemstack;
    }

    public int func_150905_g(ItemStack itemstack) {
        int meta = itemstack.getItemDamage();
        BeverageInfo beverage = this.beverages[meta];
        return beverage.heal;
    }

    public float func_150906_h(ItemStack itemstack) {
        int meta = itemstack.getItemDamage();
        BeverageInfo beverage = this.beverages[meta];
        return beverage.saturation;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 32;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        int meta = itemstack.getItemDamage();
        BeverageInfo beverage = this.beverages[meta];
        if (entityplayer.canEat(beverage.isAlwaysEdible)) {
            entityplayer.setItemInUse(itemstack, this.getMaxItemUseDuration(itemstack));
        }
        return itemstack;
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.beverages.length; ++i) {
            if (!Config.isDebug && this.beverages[i].isSecret) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        List<IBeverageEffect> effects = BeverageInfo.loadEffects(itemstack);
        for (IBeverageEffect effect : effects) {
            if (effect.getDescription() == null) continue;
            list.add(effect.getDescription());
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName(stack) + "." + this.beverages[stack.getItemDamage()].name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        for (BeverageInfo info : this.beverages) {
            info.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int i, int j) {
        if (j > 0 && this.beverages[i].secondaryColor != 0) {
            return this.beverages[i].iconBottle;
        }
        return this.beverages[i].iconContents;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getColorFromItemStack(ItemStack itemstack, int j) {
        if (j == 0 || this.beverages[itemstack.getItemDamage()].secondaryColor == 0) {
            return this.beverages[itemstack.getItemDamage()].primaryColor;
        }
        return this.beverages[itemstack.getItemDamage()].secondaryColor;
    }

    public static class BeverageInfo {
        public final String name;
        private final String iconType;
        public final int primaryColor;
        public final int secondaryColor;
        @SideOnly(value=Side.CLIENT)
        public IIcon iconBottle;
        @SideOnly(value=Side.CLIENT)
        public IIcon iconContents;
        public final int heal;
        public final float saturation;
        public final boolean isAlwaysEdible;
        public boolean isSecret = false;

        public BeverageInfo(String name, String iconType, int primaryColor, int secondaryColor, int heal, float saturation, boolean isAlwaysEdible) {
            this.name = name;
            this.iconType = iconType;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
            this.heal = heal;
            this.saturation = saturation;
            this.isAlwaysEdible = isAlwaysEdible;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerIcons(IIconRegister register) {
            this.iconBottle = TextureManager.getInstance().registerTex(register, "liquids/" + this.iconType + ".bottle");
            this.iconContents = TextureManager.getInstance().registerTex(register, "liquids/" + this.iconType + ".contents");
        }

        public static List<IBeverageEffect> loadEffects(ItemStack stack) {
            List<IBeverageEffect> effectsList = Collections.emptyList();
            NBTTagCompound nbttagcompound = stack.getTagCompound();
            if (nbttagcompound == null) {
                return effectsList;
            }
            if (nbttagcompound.hasKey("E")) {
                int effectLength = nbttagcompound.getInteger("L");
                NBTTagList nbttaglist = nbttagcompound.getTagList("E", 10);
                IBeverageEffect[] effects = new IBeverageEffect[effectLength];
                for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                    NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                    byte byte0 = nbttagcompound1.getByte("S");
                    if (byte0 < 0 || byte0 >= effects.length) continue;
                    effects[byte0] = BeverageManager.effectList[nbttagcompound1.getInteger("ID")];
                }
                effectsList = Arrays.asList(effects);
            }
            return effectsList;
        }

        public static void saveEffects(ItemStack stack, List<IBeverageEffect> effects) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagList nbttaglist = new NBTTagList();
            nbttagcompound.setInteger("L", effects.size());
            for (int i = 0; i < effects.size(); ++i) {
                IBeverageEffect effect = effects.get(i);
                if (effect == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("S", (byte)i);
                nbttagcompound1.setInteger("ID", effect.getId());
                nbttaglist.appendTag((NBTBase)nbttagcompound1);
            }
            nbttagcompound.setTag("E", (NBTBase)nbttaglist);
            stack.setTagCompound(nbttagcompound);
        }
    }
}

