/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameData;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.GuiId;
import forestry.core.utils.Utils;
import forestry.factory.triggers.FactoryTriggers;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EngineCopper
extends Engine
implements ISidedInventory {
    public static final short SLOT_FUEL = 0;
    public static final short SLOT_WASTE_1 = 1;
    public static final short SLOT_WASTE_COUNT = 4;
    private Item fuelItem;
    private int fuelItemMeta;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private final int ashForItem;
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache());

    public EngineCopper() {
        super(10000, 200000);
        this.setHints(Config.hints.get("engine.copper"));
        this.ashForItem = 7500;
        this.setInternalInventory(new EngineCopperInventoryAdapter(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.EngineCopperGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    private int getFuelSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(0) == null) {
            return -1;
        }
        if (EngineCopper.determineFuelValue(inventory.getStackInSlot(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int i = 1; i <= 4; ++i) {
            if (inventory.getStackInSlot(i) == null) {
                return i;
            }
            if (!ForestryItem.ash.isItemEqual(inventory.getStackInSlot(i)) || inventory.getStackInSlot((int)i).stackSize >= 64) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.updateOnInterval(40)) {
            return;
        }
        this.dumpStash();
        int fuelSlot = this.getFuelSlot();
        boolean hasFuel = fuelSlot >= 0 && EngineCopper.determineBurnDuration(this.getInternalInventory().getStackInSlot(fuelSlot)) > 0;
        this.getErrorLogic().setCondition(!hasFuel, EnumErrorCode.NOFUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.isRedstoneActivated()) {
                this.currentOutput = EngineCopper.determineFuelValue(new ItemStack(this.fuelItem, 1, this.fuelItemMeta));
                this.energyManager.generateEnergy(this.currentOutput);
            }
        } else if (this.isRedstoneActivated()) {
            int fuelSlot = this.getFuelSlot();
            int wasteSlot = this.getFreeWasteSlot();
            if (fuelSlot >= 0 && wasteSlot >= 0) {
                IInventoryAdapter inventory = this.getInternalInventory();
                this.burnTime = this.totalBurnTime = EngineCopper.determineBurnDuration(inventory.getStackInSlot(fuelSlot));
                if (this.burnTime > 0) {
                    this.fuelItem = inventory.getStackInSlot(fuelSlot).getItem();
                    this.decrStackSize(fuelSlot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heatToAdd = 0;
        if (this.isBurning()) {
            ++heatToAdd;
            if ((double)this.energyManager.getTotalEnergyStored() / (double)this.maxEnergy > 0.5) {
                ++heatToAdd;
            }
        }
        this.addHeat(heatToAdd);
        return heatToAdd;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteSlot = this.getFreeWasteSlot();
        if (wasteSlot >= 0) {
            IInventoryAdapter inventory = this.getInternalInventory();
            if (inventory.getStackInSlot(wasteSlot) == null) {
                inventory.setInventorySlotContents(wasteSlot, ForestryItem.ash.getItemStack());
            } else {
                ++inventory.getStackInSlot((int)wasteSlot).stackSize;
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private static int determineFuelValue(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get((Object)fuel).powerPerCycle;
        }
        return 0;
    }

    private static int determineBurnDuration(ItemStack fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return FuelManager.copperEngineFuel.get((Object)fuel).burnDuration;
        }
        return 0;
    }

    private IInventory getWasteInventory() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory == null) {
            return null;
        }
        return new InventoryMapper((IInventory)inventory, 1, 4);
    }

    private void dumpStash() {
        IInventory wasteInventory = this.getWasteInventory();
        if (wasteInventory == null) {
            return;
        }
        if (!InvTools.moveOneItemToPipe(wasteInventory, this.getTileCache())) {
            InvTools.moveItemStack(wasteInventory, this.inventoryCache.getAdjacentInventories());
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        return (float)inventory.getStackInSlot((int)fuelSlot).stackSize / (float)inventory.getStackInSlot(fuelSlot).getMaxStackSize() > percentage;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        String fuelItemName = nbttagcompound.getString("EngineFuelItem");
        if (!fuelItemName.isEmpty()) {
            this.fuelItem = (Item)GameData.getItemRegistry().getRaw(fuelItemName);
        }
        this.fuelItemMeta = nbttagcompound.getInteger("EngineFuelMeta");
        this.burnTime = nbttagcompound.getInteger("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.getInteger("EngineTotalTime");
        if (nbttagcompound.hasKey("AshProduction")) {
            this.ashProduction = nbttagcompound.getInteger("AshProduction");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.fuelItem != null) {
            nbttagcompound.setString("EngineFuelItem", GameData.getItemRegistry().getNameForObject((Object)this.fuelItem));
        }
        nbttagcompound.setInteger("EngineFuelMeta", this.fuelItemMeta);
        nbttagcompound.setInteger("EngineBurnTime", this.burnTime);
        nbttagcompound.setInteger("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.setInteger("AshProduction", this.ashProduction);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalBurnTime = j;
                break;
            }
            case 2: {
                this.currentOutput = j;
                break;
            }
            case 3: {
                this.energyManager.fromGuiInt(j);
                break;
            }
            case 4: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(containerEngine, 0, this.burnTime);
        iCrafting.sendProgressBarUpdate(containerEngine, 1, this.totalBurnTime);
        iCrafting.sendProgressBarUpdate(containerEngine, 2, this.currentOutput);
        iCrafting.sendProgressBarUpdate(containerEngine, 3, this.energyManager.toGuiInt());
        iCrafting.sendProgressBarUpdate(containerEngine, 4, this.heat);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowFuel25);
        res.add(FactoryTriggers.lowFuel10);
        return res;
    }

    private static class EngineCopperInventoryAdapter
    extends TileInventoryAdapter<EngineCopper> {
        public EngineCopperInventoryAdapter(EngineCopper engineCopper) {
            super(engineCopper, 5, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return slotIndex == 0 && FuelManager.copperEngineFuel.containsKey(itemStack);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return Utils.isIndexInRange(slotIndex, 1, 4);
        }
    }
}

