/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.PacketId;
import forestry.core.network.PacketSlotClick;
import forestry.core.network.PacketSocketUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public abstract class ContainerSocketed<T extends TileEntity & ISocketable>
extends ContainerTile<T> {
    protected ContainerSocketed(T tile, InventoryPlayer playerInventory, int xInv, int yInv) {
        super(tile, playerInventory, xInv, yInv);
    }

    public void handleChipsetClick(int slot) {
        PacketSlotClick packet = new PacketSlotClick(PacketId.CHIPSET_CLICK, this.tile, slot);
        Proxies.net.sendToServer(packet);
    }

    public void handleChipsetClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        ItemStack toSocket = itemstack.copy();
        toSocket.stackSize = 1;
        ((ISocketable)this.tile).setSocket(slot, toSocket);
        ItemStack stack = player.inventory.getItemStack();
        --stack.stackSize;
        if (stack.stackSize <= 0) {
            player.inventory.setItemStack(null);
        }
        player.updateHeldItem();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
    }

    public void handleSolderingIronClick(int slot) {
        PacketSlotClick packet = new PacketSlotClick(PacketId.SOLDERING_IRON_CLICK, this.tile, slot);
        Proxies.net.sendToServer(packet);
    }

    public void handleSolderingIronClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        ItemStack socket = ((ISocketable)this.tile).getSocket(slot);
        if (socket == null) {
            return;
        }
        StackUtils.stowInInventory(socket, (IInventory)player.inventory, true);
        if (socket.stackSize > 0) {
            return;
        }
        ((ISocketable)this.tile).setSocket(slot, null);
        itemstack.damageItem(1, (EntityLivingBase)player);
        if (itemstack.stackSize <= 0) {
            player.inventory.setItemStack(null);
        }
        player.updateHeldItem();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
    }
}

