/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.mail.gadgets.MachineTrader;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.network.PacketTraderAddress;
import net.minecraft.client.gui.GuiTextField;
import org.apache.commons.lang3.StringUtils;

public class GuiTradeName
extends GuiForestry<ContainerTradeName, MachineTrader> {
    private GuiTextField addressNameField;

    public GuiTradeName(MachineTrader tile) {
        super("textures/gui/tradername.png", new ContainerTradeName(tile), tile);
        this.xSize = 176;
        this.ySize = 90;
    }

    public void initGui() {
        super.initGui();
        this.addressNameField = new GuiTextField(this.fontRendererObj, this.guiLeft + 44, this.guiTop + 39, 90, 14);
        if (((ContainerTradeName)this.container).getAddress() != null) {
            this.addressNameField.setText(((ContainerTradeName)this.container).getAddress().getName());
        }
        this.addressNameField.setFocused(true);
    }

    protected void keyTyped(char eventCharacter, int eventKey) {
        if (this.addressNameField.isFocused()) {
            if (eventKey == 28) {
                this.setAddress();
            } else {
                this.addressNameField.textboxKeyTyped(eventCharacter, eventKey);
            }
            return;
        }
        super.keyTyped(eventCharacter, eventKey);
    }

    @Override
    protected void mouseClicked(int par1, int par2, int mouseButton) {
        super.mouseClicked(par1, par2, mouseButton);
        this.addressNameField.mouseClicked(par1, par2, mouseButton);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        super.drawGuiContainerBackgroundLayer(var1, var2, var3);
        String prompt = StringUtil.localize("gui.mail.nametrader");
        this.fontRendererObj.drawString(prompt, this.guiLeft + this.getCenteredOffset(prompt), this.guiTop + 16, this.fontColor.get("gui.mail.text"));
        this.addressNameField.drawTextBox();
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        this.setAddress();
    }

    private void setAddress() {
        String address = this.addressNameField.getText();
        if (StringUtils.isNotBlank((CharSequence)address)) {
            PacketTraderAddress packet = new PacketTraderAddress((MachineTrader)this.inventory, address);
            Proxies.net.sendToServer(packet);
        }
    }
}

