/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.config.Config;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryResource;
import forestry.mail.POBoxInfo;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiMailboxInfo
extends Gui {
    public static final GuiMailboxInfo instance = new GuiMailboxInfo();
    private final FontRenderer fontRendererObj;
    private POBoxInfo poInfo;
    private final ResourceLocation textureAlert = new ForestryResource("textures/gui/mailalert.png");

    private GuiMailboxInfo() {
        this.fontRendererObj = Proxies.common.getClientInstance().fontRenderer;
    }

    public void render(int x, int y) {
        if (this.poInfo == null) {
            return;
        }
        if (Proxies.common.getRenderWorld() == null) {
            return;
        }
        if (!Config.mailAlertEnabled) {
            return;
        }
        if (!this.poInfo.hasMail()) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.common.bindTexture(this.textureAlert);
        this.drawTexturedModalRect(x, y, 0, 0, 98, 17);
        this.fontRendererObj.drawString(Integer.toString(this.poInfo.playerLetters), x + 27 + this.getCenteredOffset(Integer.toString(this.poInfo.playerLetters), 22), y + 5, 0xFFFFFF);
        this.fontRendererObj.drawString(Integer.toString(this.poInfo.tradeLetters), x + 75 + this.getCenteredOffset(Integer.toString(this.poInfo.tradeLetters), 22), y + 5, 0xFFFFFF);
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRendererObj.getStringWidth(string)) / 2;
    }

    public boolean hasPOBoxInfo() {
        return this.poInfo != null;
    }

    public void setPOBoxInfo(POBoxInfo info) {
        boolean playJingle = false;
        if (info.hasMail()) {
            if (this.poInfo == null) {
                playJingle = true;
            } else if (this.poInfo.playerLetters != info.playerLetters || this.poInfo.tradeLetters != info.tradeLetters) {
                playJingle = true;
            }
        }
        if (playJingle) {
            Proxies.common.getRenderWorld().playSoundAtEntity((Entity)Proxies.common.getClientInstance().thePlayer, "random.levelup", 1.0f, 1.0f);
        }
        this.poInfo = info;
    }
}

