/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalState;
import forestry.api.mail.PostManager;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.mail.EnumDeliveryState;
import forestry.mail.IMailContainer;
import forestry.mail.PostRegistry;
import forestry.mail.triggers.MailTriggers;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineMailbox
extends TileBase
implements IMailContainer {
    private boolean isLinked = false;

    public MachineMailbox() {
        this.setHints(Config.hints.get("mailbox"));
        this.setInternalInventory(new InventoryAdapter(84, "Letters").disableAutomation());
    }

    @Override
    public void openGui(EntityPlayer player) {
        if (!Proxies.common.isSimulating(this.worldObj)) {
            return;
        }
        ItemStack held = player.getCurrentEquippedItem();
        if (PostManager.postRegistry.isLetter(held)) {
            IPostalState result = this.tryDispatchLetter(held);
            if (!result.isOk()) {
                player.addChatMessage((IChatComponent)new ChatComponentTranslation("for.chat.mail." + result.getIdentifier(), new Object[0]));
            } else {
                --held.stackSize;
            }
        } else {
            player.openGui(ForestryAPI.instance, GuiId.MailboxGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            this.getOrCreateMailInventory(this.worldObj, this.getAccessHandler().getOwner());
            this.isLinked = true;
        }
    }

    public IInventory getOrCreateMailInventory(World world, GameProfile playerProfile) {
        if (!Proxies.common.isSimulating(world)) {
            return this.getInternalInventory();
        }
        IMailAddress address = PostManager.postRegistry.getMailAddress(playerProfile);
        return PostRegistry.getOrCreatePOBox(this.worldObj, address);
    }

    private IPostalState tryDispatchLetter(ItemStack letterstack) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        IPostalState result = letter != null ? PostManager.postRegistry.getPostOffice(this.worldObj).lodgeLetter(this.worldObj, letterstack, true) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public boolean hasMail() {
        IInventory mailInventory = this.getOrCreateMailInventory(this.worldObj, this.getAccessHandler().getOwner());
        for (int i = 0; i < mailInventory.getSizeInventory(); ++i) {
            if (mailInventory.getStackInSlot(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(MailTriggers.triggerHasMail);
        return res;
    }
}

