/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.render;

import forestry.core.config.ForestryBlock;
import forestry.core.render.OverlayRenderingHandler;
import forestry.farming.multiblock.BlockFarm;
import forestry.plugins.PluginFarming;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;

public class FarmRenderingHandler
extends OverlayRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.renderStandardBlock(block, x, y, z);
        FarmRenderingHandler.renderFarmOverlay(world, (BlockFarm)ForestryBlock.farm.block(), x, y, z, renderer);
        return true;
    }

    private static void renderFarmOverlay(IBlockAccess world, BlockFarm block, int x, int y, int z, RenderBlocks renderer) {
        int mixedBrightness = block.getMixedBrightnessForBlock(world, x, y, z);
        int metadata = world.getBlockMetadata(x, y, z);
        float adjR = 0.5f;
        float adjG = 0.5f;
        float adjB = 0.5f;
        FarmRenderingHandler.renderBottomFace(world, (Block)block, x, y, z, renderer, BlockFarm.getOverlayTextureForBlock(0, metadata), mixedBrightness, adjR, adjG, adjB);
        FarmRenderingHandler.renderTopFace(world, (Block)block, x, y, z, renderer, BlockFarm.getOverlayTextureForBlock(1, metadata), mixedBrightness, adjR, adjG, adjB);
        FarmRenderingHandler.renderEastFace(world, (Block)block, x, y, z, renderer, BlockFarm.getOverlayTextureForBlock(2, metadata), mixedBrightness, adjR, adjG, adjB);
        FarmRenderingHandler.renderWestFace(world, (Block)block, x, y, z, renderer, BlockFarm.getOverlayTextureForBlock(3, metadata), mixedBrightness, adjR, adjG, adjB);
        FarmRenderingHandler.renderNorthFace(world, (Block)block, x, y, z, renderer, BlockFarm.getOverlayTextureForBlock(4, metadata), mixedBrightness, adjR, adjG, adjB);
        FarmRenderingHandler.renderSouthFace(world, (Block)block, x, y, z, renderer, BlockFarm.getOverlayTextureForBlock(5, metadata), mixedBrightness, adjR, adjG, adjB);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return PluginFarming.modelIdFarmBlock;
    }
}

