/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.core.config.ForestryBlock;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.core.vect.Vect;
import forestry.farming.logic.CropBlock;
import forestry.farming.logic.FarmableGenericSapling;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableVanillaShroom
extends FarmableGenericSapling {
    public FarmableVanillaShroom(Block sapling, int saplingMeta) {
        super(sapling, saplingMeta, new ItemStack[0]);
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block != Blocks.brown_mushroom_block && block != Blocks.red_mushroom_block) {
            return null;
        }
        return new CropBlock(world, block, world.getBlockMetadata(x, y, z), new Vect(x, y, z));
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        int meta = 0;
        if (StackUtils.equals((Block)Blocks.red_mushroom, germling)) {
            meta = 1;
        }
        Proxies.common.addBlockPlaceEffects(world, x, y, z, (Block)Blocks.brown_mushroom, 0);
        return ForestryBlock.mushroom.setBlock(world, x, y, z, meta);
    }
}

