/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.utils.StringUtil;
import forestry.farming.gui.IFarmLedgerDelegate;
import net.minecraft.init.Items;

public class FarmLedger
extends Ledger {
    private final IFarmLedgerDelegate delegate;

    public FarmLedger(LedgerManager ledgerManager, IFarmLedgerDelegate delegate) {
        super(ledgerManager, "farm");
        this.maxHeight = 118;
        this.delegate = delegate;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(Items.water_bucket.getIconFromDamage(0), x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(StringUtil.localize("gui.hydration"), x + 22, y + 8);
        this.drawSubheader(StringUtil.localize("gui.hydr.heat") + ':', x + 22, y + 20);
        this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationTempModifier()), x + 22, y + 32);
        this.drawSubheader(StringUtil.localize("gui.hydr.humid") + ':', x + 22, y + 44);
        this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationHumidModifier()), x + 22, y + 56);
        this.drawSubheader(StringUtil.localize("gui.hydr.rainfall") + ':', x + 22, y + 68);
        this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationRainfallModifier()) + " (" + this.delegate.getDrought() + " d)", x + 22, y + 80);
        this.drawSubheader(StringUtil.localize("gui.hydr.overall") + ':', x + 22, y + 92);
        this.drawText(StringUtil.floatAsPercent(this.delegate.getHydrationModifier()), x + 22, y + 104);
    }

    @Override
    public String getTooltip() {
        return StringUtil.floatAsPercent(this.delegate.getHydrationModifier()) + ' ' + StringUtil.localize("gui.hydration");
    }
}

