/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.gui.ContainerWorktable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiWorktable
extends GuiForestryTitled<ContainerWorktable, TileWorktable> {
    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable2.png", new ContainerWorktable(player, tile), tile);
        this.ySize = 218;
        int spacing = 18;
        int slot = 0;
        for (int y = 0; y < 3; ++y) {
            int yPos = 20 + y * 18;
            for (int x = 0; x < 3; ++x) {
                int xPos = 110 + x * 18;
                this.widgetManager.add(new MemorizedSlot(player.getEntityWorld(), this.widgetManager, xPos, yPos, slot));
                ++slot;
            }
        }
        this.widgetManager.add(new ClearWorktable(this.widgetManager, 66, 19));
    }

    private static class ClearWorktable
    extends Widget {
        public ClearWorktable(WidgetManager manager, int xPos, int yPos) {
            super(manager, xPos, yPos);
            this.width = 7;
            this.height = 7;
        }

        @Override
        public void draw(int startX, int startY) {
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            ContainerWorktable.clearRecipe();
        }
    }

    private class MemorizedSlot
    extends Widget {
        private final int slotNumber;
        private final World world;

        public MemorizedSlot(World world, WidgetManager manager, int xPos, int yPos, int slot) {
            super(manager, xPos, yPos);
            this.slotNumber = slot;
            this.world = world;
        }

        private ItemStack getOutputStack() {
            return ((TileWorktable)GuiWorktable.this.inventory).getMemory().getRecipeOutput(this.world, this.slotNumber);
        }

        @Override
        public void draw(int startX, int startY) {
            ItemStack output = this.getOutputStack();
            if (output != null) {
                this.manager.gui.drawItemStack(output, startX + this.xPos, startY + this.yPos);
            }
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (((TileWorktable)GuiWorktable.this.inventory).getMemory().isLocked(this.slotNumber)) {
                this.manager.gui.setZLevel(110.0f);
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos, TextureManager.getInstance().getDefault("slots/locked"), 16, 16);
                this.manager.gui.setZLevel(0.0f);
            }
            GL11.glPopAttrib();
        }

        @Override
        protected String getLegacyTooltip(EntityPlayer player) {
            ItemStack output = this.getOutputStack();
            return output != null ? output.getDisplayName() : null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            ContainerWorktable.sendRecipeClick(mouseButton, this.slotNumber);
        }
    }
}

