/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.statements.ITriggerExternal;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IVariableFermentable;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.factory.triggers.FactoryTriggers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineFermenter
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_FUEL = 1;
    public static final short SLOT_CAN_OUTPUT = 2;
    public static final short SLOT_CAN_INPUT = 3;
    public static final short SLOT_INPUT = 4;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    private Recipe currentRecipe;
    private float currentResourceModifier;
    private int fermentationTime = 0;
    private int fermentationTotalTime = 0;
    private int fuelBurnTime = 0;
    private int fuelTotalTime = 0;
    private int fuelCurrentFerment = 0;

    public MachineFermenter() {
        super(2000, 150, 8000);
        this.setInternalInventory(new FermenterInventoryAdapter(this));
        this.setHints(Config.hints.get("fermenter"));
        this.resourceTank = new FilteredTank(10000, RecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, RecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this.resourceTank, this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.FermenterGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("FermentationTime", this.fermentationTime);
        nbttagcompound.setInteger("FermentationTotalTime", this.fermentationTotalTime);
        nbttagcompound.setInteger("FuelBurnTime", this.fuelBurnTime);
        nbttagcompound.setInteger("FuelTotalTime", this.fuelTotalTime);
        nbttagcompound.setInteger("FuelCurrentFerment", this.fuelCurrentFerment);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fermentationTime = nbttagcompound.getInteger("FermentationTime");
        this.fermentationTotalTime = nbttagcompound.getInteger("FermentationTotalTime");
        this.fuelBurnTime = nbttagcompound.getInteger("FuelBurnTime");
        this.fuelTotalTime = nbttagcompound.getInteger("FuelTotalTime");
        this.fuelCurrentFerment = nbttagcompound.getInteger("FuelCurrentFerment");
        this.tankManager.readTanksFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void updateServerSide() {
        FluidStack fluidStack;
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(4) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 4);
        }
        if (inventory.getStackInSlot(3) != null && (fluidStack = this.productTank.getFluid()) != null) {
            FluidHelper.fillContainers(this.tankManager, (IInventory)inventory, 3, 2, fluidStack.getFluid());
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        boolean hasRecipe = RecipeManager.findMatchingRecipe(inventory.getStackInSlot(0), this.resourceTank.getFluid()) != null;
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NORECIPE);
        boolean hasResource = this.resourceTank.getFluidAmount() >= this.fuelCurrentFerment;
        errorLogic.setCondition(!hasResource, EnumErrorCode.NORESOURCE);
        boolean hasFuel = inventory.getStackInSlot(1) != null || this.fuelBurnTime > 0;
        errorLogic.setCondition(!hasFuel, EnumErrorCode.NOFUEL);
    }

    @Override
    public boolean workCycle() {
        if (this.currentRecipe == null) {
            this.checkRecipe();
            this.resetRecipe();
            IInventoryAdapter inventory = this.getInternalInventory();
            if (this.currentRecipe != null) {
                this.currentResourceModifier = MachineFermenter.determineResourceMod(inventory.getStackInSlot(0));
                this.decrStackSize(0, 1);
                return true;
            }
            return false;
        }
        if (this.fuelBurnTime > 0) {
            if (this.resourceTank.getFluidAmount() < this.fuelCurrentFerment) {
                return false;
            }
            if (this.fermentationTime <= 0) {
                return false;
            }
            int fermented = Math.min(this.fermentationTime, this.fuelCurrentFerment);
            if (!this.addProduct(new FluidStack(this.currentRecipe.output, Math.round((float)fermented * this.currentRecipe.modifier * this.currentResourceModifier)))) {
                return false;
            }
            --this.fuelBurnTime;
            this.resourceTank.drain(this.fuelCurrentFerment, true);
            this.fermentationTime -= this.fuelCurrentFerment;
            if (this.fermentationTime > 0) {
                return true;
            }
            this.currentRecipe = null;
            return true;
        }
        this.fuelBurnTime = this.fuelTotalTime = MachineFermenter.determineFuelValue(this.getFuelStack());
        if (this.fuelBurnTime > 0) {
            this.fuelCurrentFerment = MachineFermenter.determineFermentPerCycle(this.getFuelStack());
            this.decrStackSize(1, 1);
            return true;
        }
        this.fuelCurrentFerment = 0;
        return false;
    }

    private boolean addProduct(FluidStack output) {
        int amount = this.productTank.fill(output, false);
        if (amount == output.amount) {
            this.productTank.fill(output, true);
            return true;
        }
        return false;
    }

    private void checkRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        Recipe sameRec = RecipeManager.findMatchingRecipe(inventory.getStackInSlot(0), this.resourceTank.getFluid());
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fermentationTime = 0;
            this.fermentationTotalTime = 0;
            return;
        }
        this.fermentationTime = this.currentRecipe.fermentationValue;
        this.fermentationTotalTime = this.currentRecipe.fermentationValue;
    }

    private static int determineFuelValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item)) {
            return FuelManager.fermenterFuel.get((Object)item).burnDuration;
        }
        return 0;
    }

    private static int determineFermentPerCycle(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (FuelManager.fermenterFuel.containsKey(item)) {
            return FuelManager.fermenterFuel.get((Object)item).fermentPerCycle;
        }
        return 0;
    }

    private static float determineResourceMod(ItemStack itemstack) {
        if (!(itemstack.getItem() instanceof IVariableFermentable)) {
            return 1.0f;
        }
        return ((IVariableFermentable)itemstack.getItem()).getFermentationModifier(itemstack);
    }

    @Override
    public boolean isWorking() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (this.currentRecipe == null && RecipeManager.findMatchingRecipe(inventory.getStackInSlot(0), this.resourceTank.getFluid()) == null) {
            return false;
        }
        if (this.fuelBurnTime > 0) {
            return this.resourceTank.getFluidAmount() > 0 && this.productTank.getFluidAmount() < 10000;
        }
        return MachineFermenter.determineFuelValue(this.getFuelStack()) > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.getFermentationStack() == null) {
            return false;
        }
        return (float)this.getFermentationStack().stackSize / (float)this.getFermentationStack().getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        if (this.getFuelStack() == null) {
            return false;
        }
        return (float)this.getFuelStack().stackSize / (float)this.getFuelStack().getMaxStackSize() > percentage;
    }

    @Override
    public boolean hasWork() {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (this.getFuelStack() == null && this.fuelBurnTime <= 0) {
            return false;
        }
        if (this.fuelBurnTime <= 0 && RecipeManager.findMatchingRecipe(inventory.getStackInSlot(0), this.resourceTank.getFluid()) == null) {
            return false;
        }
        if (this.getFermentationStack() == null && this.fermentationTime <= 0) {
            return false;
        }
        if (this.fermentationTime <= 0 && RecipeManager.findMatchingRecipe(inventory.getStackInSlot(0), this.resourceTank.getFluid()) == null) {
            return false;
        }
        if (this.resourceTank.getFluidAmount() <= this.fuelCurrentFerment) {
            return false;
        }
        return this.productTank.getFluidAmount() < this.productTank.getCapacity();
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.fuelTotalTime == 0) {
            return 0;
        }
        return this.fuelBurnTime * i / this.fuelTotalTime;
    }

    public int getFermentationProgressScaled(int i) {
        if (this.fermentationTotalTime == 0) {
            return 0;
        }
        return this.fermentationTime * i / this.fermentationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    private ItemStack getFermentationStack() {
        return this.getInternalInventory().getStackInSlot(0);
    }

    private ItemStack getFuelStack() {
        return this.getInternalInventory().getStackInSlot(1);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        int firstMessageId = this.tankManager.maxMessageId() + 1;
        if (i == firstMessageId) {
            this.fuelBurnTime = j;
        } else if (i == firstMessageId + 1) {
            this.fuelTotalTime = j;
        } else if (i == firstMessageId + 2) {
            this.fermentationTime = j;
        } else if (i == firstMessageId + 3) {
            this.fermentationTotalTime = j;
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int firstMessageId = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, firstMessageId, this.fuelBurnTime);
        iCrafting.sendProgressBarUpdate(container, firstMessageId + 1, this.fuelTotalTime);
        iCrafting.sendProgressBarUpdate(container, firstMessageId + 2, this.fermentationTime);
        iCrafting.sendProgressBarUpdate(container, firstMessageId + 3, this.fermentationTotalTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.resourceTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.productTank.drain(quantityMax, doEmpty);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        LinkedList<ITriggerExternal> res = new LinkedList<ITriggerExternal>();
        res.add(FactoryTriggers.lowResource25);
        res.add(FactoryTriggers.lowResource10);
        return res;
    }

    private static class FermenterInventoryAdapter
    extends TileInventoryAdapter<MachineFermenter> {
        public FermenterInventoryAdapter(MachineFermenter fermenter) {
            super(fermenter, 5, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return RecipeManager.isResource(itemStack);
            }
            if (slotIndex == 4) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((MachineFermenter)this.tile).resourceTank.accepts(fluid);
            }
            if (slotIndex == 3) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex == 1) {
                return FuelManager.fermenterFuel.containsKey(itemStack);
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 2;
        }
    }

    public static class RecipeManager
    implements IFermenterManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        public static final HashSet<Fluid> recipeFluidInputs = new HashSet();
        public static final HashSet<Fluid> recipeFluidOutputs = new HashSet();

        @Override
        public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
            recipes.add(new Recipe(resource, fermentationValue, modifier, output, liquid));
            if (liquid != null) {
                recipeFluidInputs.add(liquid.getFluid());
            }
            if (output != null) {
                recipeFluidOutputs.add(output.getFluid());
            }
        }

        @Override
        public void addRecipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output) {
            this.addRecipe(resource, fermentationValue, modifier, output, Fluids.WATER.getFluid(1000));
        }

        public static Recipe findMatchingRecipe(ItemStack res, FluidStack liqu) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(res, liqu)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResource(ItemStack resource) {
            if (resource == null) {
                return false;
            }
            for (Recipe recipe : recipes) {
                if (!StackUtils.isCraftingEquivalent(recipe.resource, resource)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.resource, recipe.liquid}, new Object[]{recipe.output});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final ItemStack resource;
        public final int fermentationValue;
        public final float modifier;
        public final FluidStack output;
        public final FluidStack liquid;

        public Recipe(ItemStack resource, int fermentationValue, float modifier, FluidStack output, FluidStack liquid) {
            this.resource = resource;
            this.fermentationValue = fermentationValue;
            this.modifier = modifier;
            this.output = output;
            this.liquid = liquid;
            if (resource == null) {
                throw new NullPointerException("Fermenter Resource cannot be null!");
            }
            if (output == null) {
                throw new NullPointerException("Fermenter Output cannot be null!");
            }
            if (liquid == null) {
                throw new NullPointerException("Fermenter Liquid cannot be null!");
            }
        }

        public boolean matches(ItemStack res, FluidStack liqu) {
            if (!StackUtils.isCraftingEquivalent(this.resource, res)) {
                return false;
            }
            return liqu != null && liqu.containsFluid(this.liquid);
        }
    }
}

