/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemLiquidContainer;
import forestry.core.proxy.Proxies;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class LiquidHelper {
    public static void injectLiquidContainer(Fluids fluid, ItemStack filled) {
        Item item = filled.getItem();
        if (item.getContainerItem() instanceof ItemBucket) {
            LiquidHelper.injectLiquidContainer(fluid, 1000, filled, new ItemStack(Items.bucket));
            return;
        }
        if (item instanceof ItemLiquidContainer) {
            ItemLiquidContainer liquidContainer = (ItemLiquidContainer)item;
            switch (liquidContainer.getType()) {
                case CAN: {
                    LiquidHelper.injectTinContainer(fluid, 1000, filled, ForestryItem.canEmpty.getItemStack());
                    return;
                }
                case CAPSULE: {
                    LiquidHelper.injectWaxContainer(fluid, 1000, filled, ForestryItem.waxCapsule.getItemStack());
                    return;
                }
                case REFRACTORY: {
                    LiquidHelper.injectRefractoryContainer(fluid, 1000, filled, ForestryItem.refractoryEmpty.getItemStack());
                    return;
                }
            }
        }
        Proxies.log.warning("Unable to inject liquid container: " + filled);
    }

    public static void injectLiquidContainer(Fluids fluid, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(fluid, volume, filled, empty, null, 0);
    }

    public static void injectWaxContainer(Fluids fluid, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(fluid, volume, filled, empty, ForestryItem.beeswax.getItemStack(), 10);
    }

    public static void injectRefractoryContainer(Fluids fluid, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(fluid, volume, filled, empty, ForestryItem.refractoryWax.getItemStack(), 10);
    }

    public static void injectTinContainer(Fluids fluid, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(fluid, volume, filled, empty, ForestryItem.ingotTin.getItemStack(), 5);
    }

    public static void injectLiquidContainer(Fluids fluid, int volume, ItemStack filled, ItemStack empty, ItemStack remnant, int chance) {
        FluidStack contained = fluid.getFluid(volume);
        if (contained == null) {
            throw new IllegalArgumentException(String.format("Attempted to inject a liquid container for the non-existent liquid '%s'.", new Object[]{fluid}));
        }
        FluidContainerRegistry.FluidContainerData container = new FluidContainerRegistry.FluidContainerData(contained, filled, empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)container);
        if (RecipeManagers.squeezerManager != null && !container.filledContainer.getItem().hasContainerItem(container.filledContainer)) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filledContainer}, container.fluid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filledContainer}, container.fluid);
            }
        }
    }
}

