/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.items.ItemCrated;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class CrateRenderingHandler
implements IItemRenderer {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.locationBlocksTexture;
    private static final ResourceLocation ITEM_TEXTURE = TextureMap.locationItemsTexture;
    private static final ResourceLocation GLINT_TEXTURE = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final float PIXEL = 0.0625f;
    private final RenderItem renderItem = new RenderItem();

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case INVENTORY: 
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.render(IItemRenderer.ItemRenderType.INVENTORY, stack);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderManager.instance.options.fancyGraphics) {
                this.renderAsEntity(stack, (EntityItem)data[1]);
            } else {
                this.renderAsEntityFlat(stack);
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glPushMatrix();
            this.renderEquipped(stack);
            ItemStack contained = CrateRenderingHandler.getContainedFromCrate(stack);
            if (contained != null) {
                float scale = 0.5f;
                GL11.glScalef((float)scale, (float)scale, (float)1.1f);
                GL11.glTranslatef((float)0.625f, (float)0.5f, (float)0.001f);
                if (contained.getItem() instanceof ItemBlock) {
                    this.renderIn3D(contained);
                } else {
                    this.renderEquipped(contained);
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void renderEquipped(ItemStack stack) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.instance;
        int meta = stack.getItemDamage();
        for (int pass = 0; pass < stack.getItem().getRenderPasses(meta); ++pass) {
            IIcon icon = stack.getItem().getIconFromDamageForRenderPass(meta, pass);
            if (icon == null) continue;
            if (this.renderItem.renderWithColor) {
                int color = stack.getItem().getColorFromItemStack(stack, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
            }
            float uv1 = icon.getMinU();
            float uv2 = icon.getMaxU();
            float uv3 = icon.getMinV();
            float uv4 = icon.getMaxV();
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)uv2, (float)uv3, (float)uv1, (float)uv4, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
        }
        GL11.glPopMatrix();
    }

    private void renderAsEntity(ItemStack stack, EntityItem entity) {
        GL11.glPushMatrix();
        int iterations = 1;
        if (stack.stackSize > 1) {
            iterations = 2;
        }
        if (stack.stackSize > 15) {
            iterations = 3;
        }
        if (stack.stackSize > 31) {
            iterations = 4;
        }
        Random rand = new Random(187L);
        float offsetZ = 0.084375f;
        GL11.glRotatef((float)((((float)entity.age + 1.0f) / 20.0f + entity.hoverStart) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)(-(offsetZ * (float)iterations / 2.0f)));
        for (int count = 0; count < iterations; ++count) {
            if (count > 0) {
                float offsetX = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                float offsetY = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f / 0.5f;
                GL11.glTranslatef((float)offsetX, (float)offsetY, (float)offsetZ);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)offsetZ);
            }
            this.renderIn3D(stack);
            ItemStack contained = CrateRenderingHandler.getContainedFromCrate(stack);
            if (contained == null) continue;
            GL11.glPushMatrix();
            float scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)1.1f);
            GL11.glTranslatef((float)0.625f, (float)0.5f, (float)0.003f);
            this.renderIn3D(contained);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderIn3D(ItemStack stack) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.instance;
        if (RenderManager.instance.renderEngine == null) {
            return;
        }
        int meta = stack.getItemDamage();
        for (int pass = 0; pass < stack.getItem().getRenderPasses(meta); ++pass) {
            IIcon icon = stack.getItem().getIconFromDamageForRenderPass(meta, pass);
            if (icon == null) continue;
            if (this.renderItem.renderWithColor) {
                int color = stack.getItem().getColorFromItemStack(stack, pass);
                float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float c3 = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
            }
            float minU = icon.getMinU();
            float maxU = icon.getMaxU();
            float minV = icon.getMinV();
            float maxV = icon.getMaxV();
            if (stack.getItemSpriteNumber() == 0) {
                RenderManager.instance.renderEngine.bindTexture(BLOCK_TEXTURE);
            } else {
                RenderManager.instance.renderEngine.bindTexture(ITEM_TEXTURE);
            }
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
            if (!stack.hasEffect(pass)) continue;
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            RenderManager.instance.renderEngine.bindTexture(GLINT_TEXTURE);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f13 = 0.76f;
            GL11.glColor4f((float)(0.5f * f13), (float)(0.25f * f13), (float)(0.8f * f13), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f14 = 0.125f;
            GL11.glScalef((float)f14, (float)f14, (float)f14);
            float f15 = (float)(Minecraft.getSystemTime() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f15, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f14, (float)f14, (float)f14);
            f15 = (float)(Minecraft.getSystemTime() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f15), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
    }

    private void renderAsEntityFlat(ItemStack stack) {
        GL11.glPushMatrix();
        int iterations = 1;
        if (stack.stackSize > 1) {
            iterations = 2;
        }
        if (stack.stackSize > 15) {
            iterations = 3;
        }
        if (stack.stackSize > 31) {
            iterations = 4;
        }
        Random rand = new Random(187L);
        for (int ii = 0; ii < iterations; ++ii) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f - RenderManager.instance.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            if (ii > 0) {
                float var12 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var13 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float var14 = (rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                GL11.glTranslatef((float)var12, (float)var13, (float)var14);
            }
            GL11.glTranslatef((float)0.5f, (float)0.8f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
            this.render(IItemRenderer.ItemRenderType.ENTITY, stack);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void render(IItemRenderer.ItemRenderType type, ItemStack stack) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        IIcon crateTexture = stack.getIconIndex();
        this.renderItem.renderIcon(0, 0, crateTexture, 16, 16);
        ItemStack contained = CrateRenderingHandler.getContainedFromCrate(stack);
        if (contained != null) {
            int meta = contained.getItemDamage();
            float scale = 0.5f;
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
            GL11.glTranslatef((float)6.0f, (float)8.0f, (float)0.0f);
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
            }
            if (contained.getItem() instanceof ItemBlock) {
                GL11.glScalef((float)16.0f, (float)16.0f, (float)1.0f);
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.1f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderIn3D(contained);
            } else {
                for (int pass = 0; pass < contained.getItem().getRenderPasses(meta); ++pass) {
                    IIcon containedTexture = contained.getItem().getIconFromDamageForRenderPass(meta, pass);
                    if (containedTexture == null) continue;
                    if (this.renderItem.renderWithColor) {
                        int color = contained.getItem().getColorFromItemStack(contained, pass);
                        float c1 = (float)(color >> 16 & 0xFF) / 255.0f;
                        float c2 = (float)(color >> 8 & 0xFF) / 255.0f;
                        float c3 = (float)(color & 0xFF) / 255.0f;
                        GL11.glColor4f((float)c1, (float)c2, (float)c3, (float)1.0f);
                    }
                    this.renderItem.renderIcon(0, 0, containedTexture, 16, 16);
                }
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private static ItemStack getContainedFromCrate(ItemStack crate) {
        if (crate == null) {
            return null;
        }
        Item crateItem = crate.getItem();
        if (crateItem instanceof ItemCrated) {
            return ((ItemCrated)crateItem).getContained();
        }
        return null;
    }
}

