/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;

public class ProxyLog {
    public void finest(String message) {
        this.log(Level.TRACE, message);
    }

    public void finest(String message, Object param) {
        this.log(Level.TRACE, message, param);
    }

    public void finest(String message, Object ... params) {
        this.log(Level.TRACE, message, params);
    }

    public void finer(String message) {
        this.log(Level.TRACE, message);
    }

    public void finer(String message, Object param) {
        this.log(Level.TRACE, message, param);
    }

    public void finer(String message, Object ... params) {
        this.log(Level.TRACE, message, params);
    }

    public void fine(String message) {
        this.log(Level.DEBUG, message);
    }

    public void fine(String message, Object param) {
        this.log(Level.DEBUG, message, param);
    }

    public void fine(String message, Object ... params) {
        this.log(Level.DEBUG, message, params);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void info(String message, Object param) {
        this.log(Level.INFO, message, param);
    }

    public void info(String message, Object ... params) {
        this.log(Level.INFO, message, params);
    }

    public void warning(String message) {
        this.log(Level.WARN, message);
    }

    public void warning(String message, Object param) {
        this.log(Level.WARN, message, param);
    }

    public void warning(String message, Object ... params) {
        this.log(Level.WARN, message, params);
    }

    public void severe(String message) {
        this.log(Level.FATAL, message);
    }

    public void severe(String message, Object param) {
        this.log(Level.FATAL, message, param);
    }

    public void severe(String message, Object ... params) {
        this.log(Level.FATAL, message, params);
    }

    private void log(Level logLevel, String message) {
        LogManager.getLogger((String)"Forestry").log(logLevel, message);
    }

    private void log(Level logLevel, String message, Object ... params) {
        LogManager.getLogger((String)"Forestry").log(logLevel, (Message)new MessageFormatMessage(String.format(message, params), params));
    }

    public void logThrowable(String msg, Throwable error, Object ... args) {
        this.logThrowable(Level.ERROR, msg, 3, error, args);
    }

    public void logThrowable(String msg, int lines, Throwable error, Object ... args) {
        this.logThrowable(Level.ERROR, msg, lines, error, args);
    }

    public void logThrowable(Level level, String msg, int lines, Throwable error, Object ... args) {
        StackTraceElement[] oldtrace = error.getStackTrace();
        if (lines < oldtrace.length) {
            StackTraceElement[] newtrace = new StackTraceElement[lines];
            System.arraycopy(oldtrace, 0, newtrace, 0, newtrace.length);
            error.setStackTrace(newtrace);
        }
        LogManager.getLogger((String)"Forestry").log(level, (Message)new MessageFormatMessage(msg, args), error);
    }

    public void logErrorAPI(String mod, Throwable error, Class classFile) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        this.logThrowable(Level.ERROR, msg.toString(), 2, error, new Object[0]);
        if (classFile != null) {
            msg = new StringBuilder(mod);
            msg.append(" API error: ").append(classFile.getSimpleName()).append(" is loaded from ").append(classFile.getProtectionDomain().getCodeSource().getLocation());
            this.log(Level.ERROR, msg.toString());
        }
    }
}

