/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.client.FMLClientHandler;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.PacketId;
import java.io.IOException;
import net.minecraft.client.entity.EntityClientPlayerMP;

public class PacketProgressBarUpdate
extends ForestryPacket {
    private int windowId;
    private int dataId;
    private int value;

    public static void onPacketData(DataInputStreamForestry data) throws IOException {
        new PacketProgressBarUpdate(data);
    }

    private PacketProgressBarUpdate(DataInputStreamForestry data) throws IOException {
        super(data);
    }

    public PacketProgressBarUpdate(int windowId, int dataId, int value) {
        super(PacketId.GUI_PROGRESS_BAR);
        this.windowId = windowId;
        this.dataId = dataId;
        this.value = value;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeByte(this.windowId);
        data.writeByte(this.dataId);
        data.writeInt(this.value);
    }

    @Override
    protected void readData(DataInputStreamForestry data) throws IOException {
        this.windowId = data.readByte();
        this.dataId = data.readByte();
        this.value = data.readInt();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().thePlayer;
        if (player.openContainer != null && player.openContainer.windowId == this.windowId) {
            player.openContainer.updateProgressBar(this.dataId, this.value);
        }
    }
}

