/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryMapper
implements IInventory {
    private final IInventory inv;
    private final int start;
    private final int size;
    private int stackSizeLimit = -1;
    private boolean checkItems = true;

    public InventoryMapper(IInventory inv, ForgeDirection side) {
        this(inv, InventoryMapper.getInventoryStart(inv, side), InventoryMapper.getInventorySize(inv, side));
    }

    public InventoryMapper(IInventory inv) {
        this(inv, 0, inv.getSizeInventory(), true);
    }

    public InventoryMapper(IInventory inv, boolean checkItems) {
        this(inv, 0, inv.getSizeInventory(), checkItems);
    }

    public InventoryMapper(IInventory inv, int start, int size) {
        this(inv, start, size, true);
    }

    public InventoryMapper(IInventory inv, int start, int size, boolean checkItems) {
        this.inv = inv;
        this.start = start;
        this.size = size;
        this.checkItems = checkItems;
    }

    protected static int getInventorySize(IInventory inv, ForgeDirection side) {
        return inv.getSizeInventory();
    }

    protected static int getInventoryStart(IInventory inv, ForgeDirection side) {
        return 0;
    }

    public IInventory getBaseInventory() {
        return this.inv;
    }

    public int getSizeInventory() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(this.start + slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(this.start + slot, amount);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.inv.setInventorySlotContents(this.start + slot, itemstack);
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public void setStackSizeLimit(int limit) {
        this.stackSizeLimit = limit;
    }

    public int getInventoryStackLimit() {
        return this.stackSizeLimit > 0 ? this.stackSizeLimit : this.inv.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inv.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inv.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(this.start + slot);
    }

    public boolean hasCustomInventoryName() {
        return this.inv.hasCustomInventoryName();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (this.checkItems) {
            return this.inv.isItemValidForSlot(this.start + slot, stack);
        }
        return true;
    }
}

