/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.common.Optional;
import forestry.core.inventory.filters.ArrayStackFilter;
import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.filters.StackFilter;
import forestry.core.inventory.manipulators.InventoryManipulator;
import forestry.core.inventory.wrappers.ChestWrapper;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryCopy;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.SidedInventoryMapper;
import forestry.core.utils.AdjacentTileCache;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class InvTools {
    public static IInventory getInventoryFromTile(TileEntity tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            return new ChestWrapper(chest);
        }
        return InvTools.getInventory((IInventory)tile, side);
    }

    public static IInventory getInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMapper((ISidedInventory)inv, side);
        }
        return inv;
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            return stack.getItem().getContainerItem(stack);
        }
        stack.splitStack(1);
        return stack;
    }

    public static boolean isWildcard(ItemStack stack) {
        return InvTools.isWildcard(stack.getItemDamage());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static boolean isItemEqualStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (a.stackSize != b.stackSize) {
            return false;
        }
        if (a.getItemDamage() != b.getItemDamage()) {
            return false;
        }
        return a.stackTagCompound == null || a.stackTagCompound.equals((Object)b.stackTagCompound);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (matchNBT && !ItemStack.areItemStackTagsEqual((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.getHasSubtypes()) {
            if (InvTools.isWildcard(a) || InvTools.isWildcard(b)) {
                return true;
            }
            if (a.getItemDamage() != b.getItemDamage()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.addStack(stack);
    }

    public static boolean moveItemStack(IInventory source, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        for (IInvSlot slot : InventoryIterator.getIterable(source)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            ItemStack remainder = im.addStack(stack);
            slot.setStackInSlot(remainder);
            return !InvTools.isItemEqualStrict(stack, remainder);
        }
        return false;
    }

    public static boolean moveItemStack(IInventory source, Iterable<IInventory> destinations) {
        for (IInventory dest : destinations) {
            if (!InvTools.moveItemStack(source, dest)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack removeOneItem(IInventory inv) {
        return InvTools.removeOneItem(inv, StackFilter.ALL);
    }

    public static ItemStack removeOneItem(IInventory inv, ItemStack ... filter) {
        return InvTools.removeOneItem(inv, new ArrayStackFilter(filter));
    }

    public static ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.removeItem(filter);
    }

    public static boolean moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache) {
        return InvTools.moveOneItemToPipe(source, tileCache, ForgeDirection.VALID_DIRECTIONS);
    }

    public static boolean moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache, ForgeDirection[] directions) {
        if (PluginManager.Module.BUILDCRAFT_TRANSPORT.isEnabled()) {
            return InvTools.internal_moveOneItemToPipe(source, tileCache, directions);
        }
        return false;
    }

    @Optional.Method(modid="BuildCraftAPI|transport")
    private static boolean internal_moveOneItemToPipe(IInventory source, AdjacentTileCache tileCache, ForgeDirection[] directions) {
        InventoryCopy invClone = new InventoryCopy(source);
        ItemStack stackToMove = InvTools.removeOneItem(invClone);
        if (stackToMove == null) {
            return false;
        }
        if (stackToMove.stackSize <= 0) {
            return false;
        }
        ArrayList<AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>> pipes = new ArrayList<AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>>();
        boolean foundPipe = false;
        for (ForgeDirection side : directions) {
            IPipeTile pipe;
            TileEntity tile = tileCache.getTileOnSide(side);
            if (!(tile instanceof IPipeTile) || (pipe = (IPipeTile)tile).getPipeType() != IPipeTile.PipeType.ITEM || !pipe.isPipeConnected(side.getOpposite())) continue;
            pipes.add(new AbstractMap.SimpleEntry<ForgeDirection, IPipeTile>(side, pipe));
            foundPipe = true;
        }
        if (!foundPipe) {
            return false;
        }
        int choice = tileCache.getSource().getWorldObj().rand.nextInt(pipes.size());
        Map.Entry pipe = (Map.Entry)pipes.get(choice);
        if (((IPipeTile)pipe.getValue()).injectItem(stackToMove, false, ((ForgeDirection)pipe.getKey()).getOpposite(), null) > 0 && InvTools.removeOneItem(source, stackToMove) != null) {
            ((IPipeTile)pipe.getValue()).injectItem(stackToMove, true, ((ForgeDirection)pipe.getKey()).getOpposite(), null);
            return true;
        }
        return false;
    }

    public static boolean removeSets(IInventory inventory, int count, ItemStack[] set, EntityPlayer player, boolean stowContainer, boolean oreDictionary) {
        return InvTools.removeSets(inventory, count, set, 0, inventory.getSizeInventory(), player, stowContainer, oreDictionary, false) != null;
    }

    public static boolean removeSets(IInventory inventory, int count, ItemStack[] set, int firstSlotIndex, int slotCount, EntityPlayer player, boolean stowContainer, boolean oreDictionary) {
        return InvTools.removeSets(inventory, count, set, firstSlotIndex, slotCount, player, stowContainer, oreDictionary, false) != null;
    }

    public static ItemStack[] removeSets(IInventory inventory, int count, ItemStack[] set, int firstSlotIndex, int slotCount, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        ItemStack[] removed = new ItemStack[set.length];
        ItemStack[] stock = InvTools.getStacks(inventory, firstSlotIndex, slotCount);
        if (StackUtils.containsSets(set, stock, oreDictionary, craftingTools) < count) {
            return null;
        }
        for (int i = 0; i < set.length; ++i) {
            if (set[i] == null) continue;
            ItemStack stackToRemove = set[i].copy();
            stackToRemove.stackSize *= count;
            ItemStack removedStack = InvTools.removeStack(inventory, stackToRemove, firstSlotIndex, slotCount, player, stowContainer, false, false);
            if (removedStack == null) {
                removedStack = InvTools.removeStack(inventory, stackToRemove, firstSlotIndex, slotCount, player, stowContainer, oreDictionary, craftingTools);
            }
            removed[i] = removedStack;
        }
        return removed;
    }

    private static ItemStack removeStack(IInventory inventory, ItemStack stackToRemove, int firstSlotIndex, int slotCount, EntityPlayer player, boolean stowContainer, boolean oreDictionary, boolean craftingTools) {
        for (int j = firstSlotIndex; j < firstSlotIndex + slotCount; ++j) {
            ItemStack stackInSlot = inventory.getStackInSlot(j);
            if (stackInSlot == null || !StackUtils.isCraftingEquivalent(stackToRemove, stackInSlot, oreDictionary, craftingTools)) continue;
            ItemStack removed = inventory.decrStackSize(j, stackToRemove.stackSize);
            stackToRemove.stackSize -= removed.stackSize;
            if (stowContainer && stackToRemove.getItem().hasContainerItem(stackToRemove)) {
                StackUtils.stowContainerItem(removed, inventory, j, player);
            }
            if (stackToRemove.stackSize != 0) continue;
            return removed;
        }
        return null;
    }

    public static boolean contains(IInventory inventory, ItemStack[] query) {
        return InvTools.contains(inventory, query, 0, inventory.getSizeInventory());
    }

    public static boolean contains(IInventory inventory, ItemStack[] query, int startSlot, int slots) {
        ItemStack[] stock = InvTools.getStacks(inventory, startSlot, slots);
        return StackUtils.containsSets(query, stock) > 0;
    }

    public static boolean containsPercent(IInventory inventory, float percent) {
        return InvTools.containsPercent(inventory, percent, 0, inventory.getSizeInventory());
    }

    public static boolean containsPercent(IInventory inventory, float percent, int slot1, int length) {
        int amount = 0;
        int stackMax = 0;
        for (ItemStack itemStack : InvTools.getStacks(inventory, slot1, length)) {
            if (itemStack == null) {
                stackMax += 64;
                continue;
            }
            amount += itemStack.stackSize;
            stackMax += itemStack.getMaxStackSize();
        }
        if (stackMax == 0) {
            return false;
        }
        return (float)amount / (float)stackMax >= percent;
    }

    public static ItemStack[] getStacks(IInventory inventory) {
        ItemStack[] stacks = new ItemStack[inventory.getSizeInventory()];
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            stacks[i] = inventory.getStackInSlot(i);
        }
        return stacks;
    }

    public static ItemStack[] getStacks(IInventory inventory, int slot1, int length) {
        ItemStack[] result = new ItemStack[length];
        for (int i = slot1; i < slot1 + length; ++i) {
            result[i - slot1] = inventory.getStackInSlot(i);
        }
        return result;
    }

    public static boolean tryAddStacksCopy(IInventory inventory, ItemStack[] stacks, int startSlot, int slots, boolean all) {
        for (ItemStack stack : stacks) {
            if (stack == null || InvTools.tryAddStack(inventory, stack.copy(), startSlot, slots, all)) continue;
            return false;
        }
        return true;
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all) {
        return InvTools.tryAddStack(inventory, stack, 0, inventory.getSizeInventory(), all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, boolean all, boolean doAdd) {
        return InvTools.tryAddStack(inventory, stack, 0, inventory.getSizeInventory(), all, doAdd);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all) {
        return InvTools.tryAddStack(inventory, stack, startSlot, slots, all, true);
    }

    public static boolean tryAddStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean all, boolean doAdd) {
        int added = InvTools.addStack(inventory, stack, startSlot, slots, doAdd);
        if (all) {
            return added == stack.stackSize;
        }
        return added > 0;
    }

    public static int addStack(IInventory inventory, ItemStack stack, boolean doAdd) {
        return InvTools.addStack(inventory, stack, 0, inventory.getSizeInventory(), doAdd);
    }

    public static int addStack(IInventory inventory, ItemStack stack, int startSlot, int slots, boolean doAdd) {
        int i;
        int added = 0;
        for (i = startSlot; i < startSlot + slots; ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack == null || inventoryStack.getItem() == null || !inventoryStack.isStackable() || !inventoryStack.isItemEqual(stack) || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.stackSize - added;
            int space = inventoryStack.getMaxStackSize() - inventoryStack.stackSize;
            if (space <= 0) continue;
            if (space >= remain) {
                if (doAdd) {
                    inventoryStack.stackSize += remain;
                }
                return stack.stackSize;
            }
            if (doAdd) {
                inventoryStack.stackSize = inventoryStack.getMaxStackSize();
            }
            added += space;
        }
        if (added >= stack.stackSize) {
            return added;
        }
        for (i = startSlot; i < startSlot + slots; ++i) {
            if (inventory.getStackInSlot(i) != null) continue;
            if (doAdd) {
                inventory.setInventorySlotContents(i, stack.copy());
                inventory.getStackInSlot((int)i).stackSize = stack.stackSize - added;
            }
            return stack.stackSize;
        }
        return added;
    }
}

