/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IErrorState;
import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ErrorLedger
extends Ledger {
    @Nullable
    private IErrorState state;

    public ErrorLedger(LedgerManager manager) {
        super(manager, "error", false);
        this.maxHeight = 72;
    }

    public void setState(@Nullable IErrorState state) {
        this.state = state;
        if (state != null) {
            String helpString = StringUtil.localize(state.getHelp());
            Minecraft minecraft = Proxies.common.getClientInstance();
            FontRenderer fontRenderer = minecraft.fontRenderer;
            int lineCount = fontRenderer.listFormattedStringToWidth(helpString, 96).size();
            this.maxHeight = (lineCount + 1) * fontRenderer.FONT_HEIGHT + 20;
        }
    }

    @Override
    public void draw(int x, int y) {
        if (this.state == null) {
            return;
        }
        this.drawBackground(x, y);
        this.drawIcon(this.state.getIcon(), x + 5, y + 4);
        if (this.isFullyOpened()) {
            this.drawHeader(this.getTooltip(), x + 24, y + 8);
            String helpString = StringUtil.localize(this.state.getHelp());
            this.drawSplitText(helpString, x + 24, y + 20, 96);
        }
    }

    @Override
    public boolean isVisible() {
        return this.state != null;
    }

    @Override
    public String getTooltip() {
        if (this.state == null) {
            return "";
        }
        return StringUtil.localize(this.state.getDescription());
    }
}

