/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.delegates.FakeAccessHandler;
import forestry.core.gui.ContainerForestry;
import forestry.core.interfaces.IAccessHandler;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.interfaces.IRestrictedAccessTile;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketErrorUpdate;
import forestry.core.network.PacketGuiEnergy;
import forestry.core.network.PacketGuiUpdate;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.Utils;
import forestry.energy.EnergyManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public abstract class ContainerTile<T extends TileEntity>
extends ContainerForestry {
    protected final T tile;
    private final IAccessHandler accessHandler;
    private ImmutableSet<IErrorState> previousErrorStates;
    private int previousEnergyManagerData = 0;
    private EnumAccess previousAccess;

    protected ContainerTile(T tile) {
        this.tile = tile;
        this.accessHandler = tile instanceof IRestrictedAccessTile ? ((IRestrictedAccessTile)tile).getAccessHandler() : FakeAccessHandler.getInstance();
    }

    protected ContainerTile(T tileForestry, InventoryPlayer playerInventory, int xInv, int yInv) {
        this(tileForestry);
        this.addPlayerInventory(playerInventory, xInv, yInv);
    }

    @Override
    protected final boolean canAccess(EntityPlayer player) {
        return player != null && this.accessHandler.allowsAlteration(player);
    }

    public final boolean canInteractWith(EntityPlayer entityplayer) {
        return Utils.isUseableByPlayer(entityplayer, this.tile) && this.accessHandler.allowsViewing(entityplayer);
    }

    public void detectAndSendChanges() {
        IRestrictedAccessTile restrictedAccessTile;
        IAccessHandler accessHandler;
        EnumAccess access;
        EnergyManager energyManager;
        int energyManagerData;
        ForestryPacket packet;
        super.detectAndSendChanges();
        if (this.tile instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.tile;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (this.previousErrorStates != null && !errorStates.equals(this.previousErrorStates)) {
                packet = new PacketErrorUpdate((TileEntity)this.tile, errorLogicSource);
                this.sendPacketToCrafters(packet);
            }
            this.previousErrorStates = errorStates;
        }
        if (this.tile instanceof IPowerHandler && (energyManagerData = (energyManager = ((IPowerHandler)this.tile).getEnergyManager()).toGuiInt()) != this.previousEnergyManagerData) {
            packet = new PacketGuiEnergy(this.windowId, energyManagerData);
            this.sendPacketToCrafters(packet);
            this.previousEnergyManagerData = energyManagerData;
        }
        if (this.tile instanceof IRestrictedAccessTile && (access = (accessHandler = (restrictedAccessTile = (IRestrictedAccessTile)this.tile).getAccessHandler()).getAccessType()) != this.previousAccess) {
            PacketGuiUpdate packet2 = new PacketGuiUpdate((IStreamableGui)this.tile);
            this.sendPacketToCrafters(packet2);
            this.previousAccess = access;
        }
    }

    public void onGuiEnergy(int energyStored) {
        if (this.tile instanceof IPowerHandler) {
            EnergyManager energyManager = ((IPowerHandler)this.tile).getEnergyManager();
            energyManager.fromGuiInt(energyStored);
        }
    }
}

