/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.GuiHandler;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.TileInventoryAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private final int guiID;

    public TileNaturalistChest(ISpeciesRoot speciesRoot, int guiId) {
        this.setInternalInventory(new NaturalistInventoryAdapter(this, speciesRoot));
        this.setHints(Config.hints.get("apiarist.chest"));
        this.guiID = guiId;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, this.guiID, player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void flipPage(EntityPlayer player, int page) {
        player.openGui(ForestryAPI.instance, GuiHandler.encodeGuiData(this.guiID, page), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    private static class NaturalistInventoryAdapter
    extends TileInventoryAdapter<TileNaturalistChest> {
        private final ISpeciesRoot speciesRoot;

        public NaturalistInventoryAdapter(TileNaturalistChest tile, ISpeciesRoot speciesRoot) {
            super(tile, 125, "Items");
            this.speciesRoot = speciesRoot;
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemstack) {
            return this.speciesRoot.isMember(itemstack);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack stack, int side) {
            return true;
        }
    }
}

