/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineDefinition {
    public final Class<? extends TileEntity> teClass;
    private final String teIdent;
    private Block block;
    private final int meta;
    public final IBlockRenderer renderer;
    public IRecipe[] recipes;
    private final int[] faceMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public MachineDefinition(int meta, String teIdent, Class<? extends TileEntity> teClass, IRecipe ... recipes) {
        this(meta, teIdent, teClass, (IBlockRenderer)null, recipes);
    }

    public MachineDefinition(int meta, String teIdent, Class<? extends TileEntity> teClass, IBlockRenderer renderer, IRecipe ... recipes) {
        this.meta = meta;
        this.teIdent = teIdent;
        this.teClass = teClass;
        this.renderer = renderer;
        this.recipes = recipes;
        this.faceMap = new int[8];
        for (int i = 0; i < 8; ++i) {
            this.faceMap[i] = 0;
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void register() {
        this.registerTileEntity();
        this.registerCrafting();
        if (this.renderer != null) {
            Proxies.render.registerTESR(this);
        }
    }

    private void registerCrafting() {
        for (IRecipe recipe : this.recipes) {
            if (recipe == null) continue;
            CraftingManager.getInstance().getRecipeList().add(recipe);
        }
    }

    private void registerTileEntity() {
        GameRegistry.registerTileEntity(this.teClass, (String)this.teIdent);
    }

    public TileEntity createMachine() {
        try {
            return this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate tile entity of class " + this.teClass.getName());
        }
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, this.meta));
    }

    public boolean isSolidOnSide(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side) {
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return false;
    }

    public MachineDefinition setFaces(int ... faces) {
        if (faces.length > 6) {
            System.arraycopy(faces, 0, this.faceMap, 0, faces.length);
        } else {
            System.arraycopy(faces, 0, this.faceMap, 0, 6);
            this.faceMap[6] = faces[0];
            this.faceMap[7] = faces[1];
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[8];
        for (int i = 0; i < 8; ++i) {
            this.icons[i] = TextureManager.getInstance().registerTex(register, this.teIdent.replace("forestry.", "").toLowerCase(Locale.ENGLISH) + "." + this.faceMap[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBlockTextureForSide(int side) {
        return this.icons[side];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileForestry)) {
            return this.getBlockTextureForSide(side);
        }
        ForgeDirection dir = ((TileForestry)tile).getOrientation();
        switch (dir) {
            case WEST: {
                side = side == 2 ? 4 : (side == 3 ? 5 : (side == 4 ? 3 : (side == 5 ? 2 : (side == 0 ? 6 : 7))));
                break;
            }
            case EAST: {
                side = side == 2 ? 5 : (side == 3 ? 4 : (side == 4 ? 2 : (side == 5 ? 3 : (side == 0 ? 6 : 7))));
                break;
            }
            case SOUTH: {
                break;
            }
            case NORTH: {
                side = side == 2 ? 3 : (side == 3 ? 2 : (side == 4 ? 5 : (side == 5 ? 4 : side)));
                break;
            }
        }
        return this.getBlockTextureForSide(side);
    }
}

