/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.core.commands.CommandHelpers;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.SubCommand;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.World;

public final class CommandModeSet
extends SubCommand {
    private final String[] modeStringArr;
    private final ICommandModeHelper modeSetter;

    public CommandModeSet(ICommandModeHelper modeSetter) {
        super("set");
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
        this.modeSetter = modeSetter;
        this.modeStringArr = modeSetter.getModeNames();
    }

    @Override
    public void processSubCommand(ICommandSender sender, String[] args) {
        if (args.length == 0 || args.length > 2) {
            this.printHelp(sender);
            return;
        }
        World world = args.length == 2 ? CommandHelpers.getWorld(sender, this, args, 0) : CommandHelpers.getWorld(sender, this);
        String desired = args[args.length - 1];
        String modeName = this.modeSetter.getModeNameMatching(desired);
        if (modeName == null) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.set.error", desired);
            this.printHelp(sender);
            return;
        }
        this.modeSetter.setMode(world, modeName);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.mode.set.success", modeName);
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] incomplete) {
        return CommandHelpers.getListOfStringsMatchingLastWord(incomplete, this.modeStringArr);
    }
}

