/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IIndividual;
import forestry.arboriculture.genetics.ICheckPollinatable;
import java.util.EnumSet;
import net.minecraftforge.common.EnumPlantType;

public class CheckPollinatableTree
implements ICheckPollinatable {
    private final ITree tree;

    public CheckPollinatableTree(ITree tree) {
        this.tree = tree;
    }

    @Override
    public EnumSet<EnumPlantType> getPlantType() {
        return this.tree.getPlantTypes();
    }

    @Override
    public IIndividual getPollen() {
        return this.tree;
    }

    @Override
    public boolean canMateWith(IIndividual pollen) {
        if (this.tree.getMate() != null) {
            return false;
        }
        if (!(pollen instanceof ITree)) {
            return false;
        }
        return !this.tree.isGeneticEqual(pollen);
    }
}

