/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum WoodType {
    LARCH,
    TEAK,
    ACACIA,
    LIME,
    CHESTNUT,
    WENGE,
    BAOBAB,
    SEQUOIA(4.0f),
    KAPOK,
    EBONY,
    MAHOGANY,
    BALSA(1.0f),
    WILLOW,
    WALNUT,
    GREENHEART(7.5f),
    CHERRY,
    MAHOE,
    POPLAR,
    PALM,
    PAPAYA,
    PINE(3.0f),
    PLUM,
    MAPLE,
    CITRUS,
    GIGANTEUM,
    IPE,
    PADAUK,
    COCOBOLO,
    ZEBRAWOOD;

    public static final float DEFAULT_HARDNESS = 2.0f;
    public static final WoodType[] VALUES;
    private final float hardness;
    private ItemStack log;
    private ItemStack logFireproof;
    private ItemStack planks;
    private ItemStack planksFireproof;
    private ItemStack slab;
    private ItemStack slabFireproof;
    private ItemStack fence;
    private ItemStack fenceFireproof;
    private ItemStack stairs;
    private ItemStack stairsFireproof;
    @SideOnly(value=Side.CLIENT)
    private static IIcon[][] icons;

    private WoodType() {
        this(2.0f);
    }

    private WoodType(float hardness) {
        this.hardness = hardness;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        icons = new IIcon[3][VALUES.length];
        for (int i = 0; i < VALUES.length; ++i) {
            WoodType woodType = VALUES[i];
            String woodName = woodType.toString().toLowerCase(Locale.ENGLISH);
            WoodType.icons[0][i] = TextureManager.getInstance().registerTex(register, "wood/planks." + woodName);
            WoodType.icons[1][i] = TextureManager.getInstance().registerTex(register, "wood/bark." + woodName);
            WoodType.icons[2][i] = TextureManager.getInstance().registerTex(register, "wood/heart." + woodName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getPlankIcon() {
        return icons[0][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBarkIcon() {
        return icons[1][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getHeartIcon() {
        return icons[2][this.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int meta, int side) {
        int oriented = meta & 0xC;
        switch (oriented) {
            case 4: {
                if (side > 3) {
                    return this.getHeartIcon();
                }
                return this.getBarkIcon();
            }
            case 8: {
                if (side == 2 || side == 3) {
                    return this.getHeartIcon();
                }
                return this.getBarkIcon();
            }
        }
        if (side < 2) {
            return this.getHeartIcon();
        }
        return this.getBarkIcon();
    }

    public float getHardness() {
        return this.hardness;
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.setInteger("WoodType", this.ordinal());
    }

    public static WoodType getFromCompound(NBTTagCompound compound) {
        int typeOrdinal;
        if (compound != null && (typeOrdinal = compound.getInteger("WoodType")) < VALUES.length) {
            return VALUES[typeOrdinal];
        }
        return LARCH;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ENGLISH);
    }

    private ItemStack getStack(Block block) {
        NBTTagCompound woodNBT = new NBTTagCompound();
        this.saveToCompound(woodNBT);
        ItemStack itemStack = new ItemStack(block);
        itemStack.setTagCompound(woodNBT);
        return itemStack;
    }

    public void registerLog(Block block, boolean fireproof) {
        ItemStack itemStack = this.getStack(block);
        if (fireproof) {
            this.logFireproof = itemStack;
        } else {
            this.log = itemStack;
        }
    }

    public void registerPlanks(Block block, boolean fireproof) {
        ItemStack itemStack = this.getStack(block);
        if (fireproof) {
            this.planksFireproof = itemStack;
        } else {
            this.planks = itemStack;
        }
    }

    public void registerSlab(Block block, boolean fireproof) {
        ItemStack itemStack = this.getStack(block);
        if (fireproof) {
            this.slabFireproof = itemStack;
        } else {
            this.slab = itemStack;
        }
    }

    public void registerFence(Block block, boolean fireproof) {
        ItemStack itemStack = this.getStack(block);
        if (fireproof) {
            this.fenceFireproof = itemStack;
        } else {
            this.fence = itemStack;
        }
    }

    public void registerStairs(Block block, boolean fireproof) {
        ItemStack itemStack = this.getStack(block);
        if (fireproof) {
            this.stairsFireproof = itemStack;
        } else {
            this.stairs = itemStack;
        }
    }

    public ItemStack getPlanks(boolean fireproof) {
        if (fireproof) {
            return this.planksFireproof.copy();
        }
        return this.planks.copy();
    }

    public ItemStack getLog(boolean fireproof) {
        if (fireproof) {
            return this.logFireproof.copy();
        }
        return this.log.copy();
    }

    public ItemStack getSlab(boolean fireproof) {
        if (fireproof) {
            return this.slabFireproof.copy();
        }
        return this.slab.copy();
    }

    public ItemStack getFence(boolean fireproof) {
        if (fireproof) {
            return this.fenceFireproof.copy();
        }
        return this.fence.copy();
    }

    public ItemStack getStairs(boolean fireproof) {
        if (fireproof) {
            return this.stairsFireproof.copy();
        }
        return this.stairs.copy();
    }

    public static WoodType getRandom(Random random) {
        return VALUES[random.nextInt(VALUES.length)];
    }

    static {
        VALUES = WoodType.values();
    }
}

