/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.apiculture.gadgets.TileSwarm;
import forestry.apiculture.worldgen.HiveGenGround;
import forestry.core.config.ForestryBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class HiveDescriptionSwarmer
implements IHiveDescription {
    private final ItemStack[] bees;

    public HiveDescriptionSwarmer(ItemStack ... bees) {
        this.bees = bees;
    }

    @Override
    public IHiveGen getHiveGen() {
        return new HiveGenGround(new Block[]{Blocks.dirt, Blocks.grass});
    }

    @Override
    public Block getBlock() {
        return ForestryBlock.beehives.block();
    }

    @Override
    public int getMeta() {
        return 8;
    }

    @Override
    public boolean isGoodBiome(BiomeGenBase biome) {
        return true;
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        return true;
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        return true;
    }

    @Override
    public float getGenChance() {
        return 128.0f;
    }

    @Override
    public void postGen(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileSwarm) {
            ((TileSwarm)tile).setContained(this.bees);
        }
    }
}

