/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.genetics.EffectData;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class AlleleEffectCreeper
extends AlleleEffectThrottled {
    private static final int explosionChance = 50;
    private static final byte defaultForce = 12;
    private static final byte indexExplosionTimer = 1;
    private static final byte indexExplosionForce = 2;

    public AlleleEffectCreeper() {
        super("creeper", true, 20, false, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (!(storedData instanceof EffectData)) {
            return new EffectData(3, 0);
        }
        if (((EffectData)storedData).getIntSize() < 3) {
            return new EffectData(3, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        ChunkCoordinates housingCoords = housing.getCoordinates();
        if (storedData.getInteger(1) > 0) {
            AlleleEffectCreeper.progressExplosion(storedData, world, housingCoords.posX, housingCoords.posY, housingCoords.posZ);
            return storedData;
        }
        AxisAlignedBB infectionBox = this.getBounding(genome, housing);
        List list = world.getEntitiesWithinAABB(EntityPlayer.class, infectionBox);
        for (Object obj : list) {
            EntityPlayer player = (EntityPlayer)obj;
            int chance = 50;
            storedData.setInteger(2, 12);
            int count = ItemArmorApiarist.wearsItems(player, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                storedData.setInteger(2, 6);
            } else if (count > 1) {
                chance = 20;
                storedData.setInteger(2, 8);
            } else if (count > 0) {
                chance = 35;
                storedData.setInteger(2, 10);
            }
            if (world.rand.nextInt(1000) >= chance) continue;
            world.playSoundEffect((double)housingCoords.posX, (double)housingCoords.posY, (double)housingCoords.posZ, "mob.creeper", 4.0f, (1.0f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.2f) * 0.7f);
            storedData.setInteger(1, 2);
        }
        return storedData;
    }

    private static void progressExplosion(IEffectData storedData, World world, int x, int y, int z) {
        int explosionTimer = storedData.getInteger(1);
        storedData.setInteger(1, --explosionTimer);
        if (explosionTimer > 0) {
            return;
        }
        world.createExplosion(null, (double)x, (double)y, (double)z, (float)storedData.getInteger(2), false);
    }
}

