/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.IFlowerProvider;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class HasFlowersCache
implements INBTTagable {
    private static final String nbtKey = "hasFlowerCache";
    private ChunkCoordinates flowerCoords = null;
    private int cooldown = 0;

    public boolean hasFlowers(IBee queen, IBeeHousing beeHousing) {
        IFlowerProvider flowerProvider = queen.getGenome().getFlowerProvider();
        String flowerType = flowerProvider.getFlowerType();
        World world = beeHousing.getWorld();
        if (this.flowerCoords != null) {
            if (world.getTotalWorldTime() % 100L != 0L) {
                return true;
            }
            if (FlowerManager.flowerRegistry.isAcceptedFlower(flowerType, world, this.flowerCoords.posX, this.flowerCoords.posY, this.flowerCoords.posZ)) {
                return true;
            }
            this.flowerCoords = null;
            this.cooldown = 0;
        }
        if (this.cooldown <= 0) {
            this.flowerCoords = FlowerManager.flowerRegistry.getAcceptedFlowerCoordinates(beeHousing, queen, flowerType);
            this.cooldown = 550;
        } else {
            --this.cooldown;
        }
        return this.flowerCoords != null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (!nbttagcompound.hasKey(nbtKey)) {
            return;
        }
        NBTTagCompound hasFlowerCacheNBT = nbttagcompound.getCompoundTag(nbtKey);
        if (hasFlowerCacheNBT.hasKey("flowerX")) {
            int x = hasFlowerCacheNBT.getInteger("flowerX");
            int y = hasFlowerCacheNBT.getInteger("flowerY");
            int z = hasFlowerCacheNBT.getInteger("flowerZ");
            this.flowerCoords = new ChunkCoordinates(x, y, z);
        }
        this.cooldown = hasFlowerCacheNBT.getInteger("cooldown");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound hasFlowerCacheNBT = new NBTTagCompound();
        if (this.flowerCoords != null) {
            hasFlowerCacheNBT.setInteger("flowerX", this.flowerCoords.posX);
            hasFlowerCacheNBT.setInteger("flowerY", this.flowerCoords.posY);
            hasFlowerCacheNBT.setInteger("flowerZ", this.flowerCoords.posZ);
        }
        hasFlowerCacheNBT.setInteger("cooldown", this.cooldown);
        nbttagcompound.setTag(nbtKey, (NBTBase)hasFlowerCacheNBT);
    }
}

