/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.BeeHousingListener;
import forestry.apiculture.BeeHousingModifier;
import forestry.apiculture.HasFlowersCache;
import forestry.apiculture.network.PacketBeekeepingLogicActive;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginApiculture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class BeekeepingLogic
implements IBeekeepingLogic,
IStreamable {
    private static final int totalBreedingTime = 100;
    private final IBeeHousing housing;
    private final IBeeModifier beeModifier;
    private final IBeeListener beeListener;
    private int beeProgress;
    private int beeProgressMax;
    private int queenWorkCycleThrottle;
    private IEffectData[] effectData = new IEffectData[2];
    private final Stack<ItemStack> spawn = new Stack();
    private final HasFlowersCache hasFlowersCache = new HasFlowersCache();
    private final QueenCanWorkCache queenCanWorkCache = new QueenCanWorkCache();
    private final PollenHandler pollenHandler = new PollenHandler();
    private boolean active;
    private IBee queen;
    private ItemStack queenStack;

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
        this.beeModifier = new BeeHousingModifier(housing);
        this.beeListener = new BeeHousingListener(housing);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.beeProgress = nbttagcompound.getInteger("BreedingTime");
        this.queenWorkCycleThrottle = nbttagcompound.getInteger("Throttle");
        NBTTagCompound queenNBT = nbttagcompound.getCompoundTag("queen");
        this.queenStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)queenNBT);
        this.queen = BeeManager.beeRoot.getMember(this.queenStack);
        this.setActive(nbttagcompound.getBoolean("Active"));
        this.hasFlowersCache.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Offspring", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            this.spawn.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttaglist.getCompoundTagAt(i)));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("BreedingTime", this.beeProgress);
        nbttagcompound.setInteger("Throttle", this.queenWorkCycleThrottle);
        if (this.queenStack != null) {
            NBTTagCompound queenNBT = new NBTTagCompound();
            this.queenStack.writeToNBT(queenNBT);
            nbttagcompound.setTag("queen", (NBTBase)queenNBT);
        }
        nbttagcompound.setBoolean("Active", this.active);
        this.hasFlowersCache.writeToNBT(nbttagcompound);
        Stack<ItemStack> spawnCopy = new Stack<ItemStack>();
        spawnCopy.addAll(this.spawn);
        NBTTagList nbttaglist = new NBTTagList();
        while (!spawnCopy.isEmpty()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemStack)spawnCopy.pop()).writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbttagcompound.setTag("Offspring", (NBTBase)nbttaglist);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeBoolean(this.active);
        if (this.active) {
            data.writeItemStack(this.queenStack);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        boolean active = data.readBoolean();
        this.setActive(active);
        if (active) {
            this.queenStack = data.readItemStack();
            this.queen = BeeManager.beeRoot.getMember(this.queenStack);
        }
    }

    private void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        this.syncToClient();
    }

    @Override
    public boolean canWork() {
        IErrorLogic errorLogic = this.housing.getErrorLogic();
        errorLogic.clearErrors();
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        boolean hasSpace = BeekeepingLogic.addPendingProducts(beeInventory, this.spawn);
        errorLogic.setCondition(!hasSpace, EnumErrorCode.NOSPACE);
        ItemStack queenStack = beeInventory.getQueen();
        if (ForestryItem.beePrincessGE.isItemEqual(queenStack)) {
            boolean hasDrone = BeeManager.beeRoot.isDrone(beeInventory.getDrone());
            errorLogic.setCondition(!hasDrone, EnumErrorCode.NODRONE);
            this.setActive(false);
            return !errorLogic.hasErrors();
        }
        if (ForestryItem.beeQueenGE.isItemEqual(queenStack)) {
            if (!BeekeepingLogic.isQueenAlive(queenStack)) {
                IBee dyingQueen = BeeManager.beeRoot.getMember(queenStack);
                Collection<ItemStack> spawned = BeekeepingLogic.killQueen(dyingQueen, this.housing, this.beeListener);
                this.spawn.addAll(spawned);
                queenStack = null;
            }
        } else {
            queenStack = null;
        }
        if (!ItemStack.areItemStacksEqual((ItemStack)this.queenStack, (ItemStack)queenStack)) {
            this.queen = BeeManager.beeRoot.getMember(queenStack);
            this.queenStack = queenStack;
        }
        if (errorLogic.setCondition(this.queen == null, EnumErrorCode.NOQUEEN)) {
            this.setActive(false);
            return false;
        }
        Set<IErrorState> queenErrors = this.queenCanWorkCache.queenCanWork(this.queen, this.housing);
        for (IErrorState errorState : queenErrors) {
            errorLogic.setCondition(true, errorState);
        }
        boolean hasFlowers = this.hasFlowersCache.hasFlowers(this.queen, this.housing);
        errorLogic.setCondition(!hasFlowers, EnumErrorCode.NOFLOWER);
        boolean canWork = !errorLogic.hasErrors();
        this.setActive(canWork);
        return canWork;
    }

    @Override
    public void doWork() {
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        ItemStack queenStack = beeInventory.getQueen();
        if (ForestryItem.beePrincessGE.isItemEqual(queenStack)) {
            this.tickBreed();
        } else {
            this.queenWorkTick(this.queen);
        }
    }

    private void queenWorkTick(IBee queen) {
        if (queen == null) {
            return;
        }
        this.effectData = queen.doEffect(this.effectData, this.housing);
        ++this.queenWorkCycleThrottle;
        if (this.queenWorkCycleThrottle >= 550) {
            this.queenWorkCycleThrottle = 0;
            BeekeepingLogic.doProduction(queen, this.housing, this.beeListener);
            queen.plantFlowerRandom(this.housing);
            this.pollenHandler.doPollination(queen, this.housing, this.beeListener);
            float lifespanModifier = this.beeModifier.getLifespanModifier(queen.getGenome(), queen.getMate(), 1.0f);
            queen.age(this.housing.getWorld(), lifespanModifier);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            queen.writeToNBT(nbttagcompound);
            this.housing.getBeeInventory().getQueen().setTagCompound(nbttagcompound);
        }
        this.beeProgress = queen.getHealth();
        this.beeProgressMax = queen.getMaxHealth();
    }

    private static void doProduction(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
        ItemStack[] products = queen.produceStacks(beeHousing);
        if (products == null) {
            return;
        }
        beeListener.wearOutEquipment(1);
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        for (ItemStack stack : products) {
            beeInventory.addProduct(stack, false);
        }
    }

    private static boolean addPendingProducts(IBeeHousingInventory beeInventory, Stack<ItemStack> spawn) {
        boolean housingHasSpace = true;
        while (!spawn.isEmpty()) {
            ItemStack next = spawn.peek();
            if (beeInventory.addProduct(next, true)) {
                spawn.pop();
                continue;
            }
            housingHasSpace = false;
            break;
        }
        return housingHasSpace;
    }

    private static boolean isQueenAlive(ItemStack queenStack) {
        NBTTagCompound nbtTagCompound = queenStack.getTagCompound();
        int health = nbtTagCompound.getInteger("Health");
        return health > 0;
    }

    private void tickBreed() {
        this.beeProgressMax = 100;
        IBeeHousingInventory beeInventory = this.housing.getBeeInventory();
        ItemStack droneStack = beeInventory.getDrone();
        ItemStack princessStack = beeInventory.getQueen();
        if (!ForestryItem.beeDroneGE.isItemEqual(droneStack) || !ForestryItem.beePrincessGE.isItemEqual(princessStack)) {
            this.beeProgress = 0;
            return;
        }
        if (this.beeProgress < 100) {
            ++this.beeProgress;
        }
        if (this.beeProgress < 100) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(princessStack);
        IBee drone = BeeManager.beeRoot.getMember(droneStack);
        princess.mate(drone);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        princess.writeToNBT(nbttagcompound);
        this.queenStack = ForestryItem.beeQueenGE.getItemStack();
        this.queenStack.setTagCompound(nbttagcompound);
        beeInventory.setQueen(this.queenStack);
        BeeManager.beeRoot.getBreedingTracker(this.housing.getWorld(), this.housing.getOwner()).registerQueen(princess);
        --beeInventory.getDrone().stackSize;
        if (beeInventory.getDrone().stackSize <= 0) {
            beeInventory.setDrone(null);
        }
        this.queen = princess;
        this.beeProgress = princess.getHealth();
        this.beeProgressMax = princess.getMaxHealth();
    }

    private static Collection<ItemStack> killQueen(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
        Collection<ItemStack> spawn;
        if (queen == null) {
            return Collections.emptySet();
        }
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        if (queen.canSpawn()) {
            spawn = BeekeepingLogic.spawnOffspring(queen, beeHousing);
            beeListener.onQueenDeath();
            beeInventory.getQueen().stackSize = 0;
            beeInventory.setQueen(null);
        } else {
            Proxies.log.warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.");
            ItemStack convert = ForestryItem.beePrincessGE.getItemStack();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            queen.writeToNBT(nbttagcompound);
            convert.setTagCompound(nbttagcompound);
            spawn = Collections.singleton(convert);
            beeInventory.setQueen(null);
        }
        return spawn;
    }

    private static Collection<ItemStack> spawnOffspring(IBee queen, IBeeHousing beeHousing) {
        IBee[] drones;
        int count;
        World world = beeHousing.getWorld();
        Stack<ItemStack> offspring = new Stack<ItemStack>();
        IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker(world, beeHousing.getOwner());
        boolean secondPrincess = (double)world.rand.nextInt(10000) < PluginApiculture.getSecondPrincessChance() * 100.0;
        int n = count = secondPrincess ? 2 : 1;
        while (count > 0) {
            --count;
            IBee heiress = queen.spawnPrincess(beeHousing);
            if (heiress == null) continue;
            ItemStack princess = BeeManager.beeRoot.getMemberStack(heiress, EnumBeeType.PRINCESS.ordinal());
            breedingTracker.registerPrincess(heiress);
            offspring.push(princess);
        }
        for (IBee drone : drones = queen.spawnDrones(beeHousing)) {
            ItemStack droneStack = BeeManager.beeRoot.getMemberStack(drone, EnumBeeType.DRONE.ordinal());
            breedingTracker.registerDrone(drone);
            offspring.push(droneStack);
        }
        IBeeHousingInventory beeInventory = beeHousing.getBeeInventory();
        ArrayList<ItemStack> spawn = new ArrayList<ItemStack>();
        while (!offspring.isEmpty()) {
            ItemStack spawned = (ItemStack)offspring.pop();
            if (beeInventory.addProduct(spawned, true)) continue;
            spawn.add(spawned);
        }
        return spawn;
    }

    @Override
    public void syncToClient() {
        World world = this.housing.getWorld();
        if (world != null && !world.isRemote) {
            Proxies.net.sendNetworkPacket(new PacketBeekeepingLogicActive(this.housing), world);
        }
    }

    @Override
    public int getBeeProgressPercent() {
        if (this.beeProgressMax == 0) {
            return 0;
        }
        return Math.round((float)this.beeProgress * 100.0f / (float)this.beeProgressMax);
    }

    @Override
    public boolean canDoBeeFX() {
        return this.active;
    }

    @Override
    public void doBeeFX() {
        if (this.queen != null) {
            this.queen.doFX(this.effectData, this.housing);
        }
    }

    private static class PollenHandler {
        private static final int MAX_POLLINATION_ATTEMPTS = 20;
        private IIndividual pollen;
        private int attemptedPollinations = 0;

        private PollenHandler() {
        }

        public void doPollination(IBee queen, IBeeHousing beeHousing, IBeeListener beeListener) {
            if (this.pollen == null) {
                this.attemptedPollinations = 0;
                this.pollen = queen.retrievePollen(beeHousing);
                if (this.pollen != null && beeListener.onPollenRetrieved(this.pollen)) {
                    this.pollen = null;
                }
            }
            if (this.pollen != null) {
                ++this.attemptedPollinations;
                if (queen.pollinateRandom(beeHousing, this.pollen) || this.attemptedPollinations >= 20) {
                    this.pollen = null;
                }
            }
        }
    }

    private static class QueenCanWorkCache {
        private static final int ticksPerCheckQueenCanWork = 10;
        private Set<IErrorState> queenCanWorkCached = Collections.emptySet();
        private int queenCanWorkCooldown = 0;

        private QueenCanWorkCache() {
        }

        public Set<IErrorState> queenCanWork(IBee queen, IBeeHousing beeHousing) {
            if (this.queenCanWorkCooldown <= 0) {
                this.queenCanWorkCached = queen.getCanWork(beeHousing);
                this.queenCanWorkCooldown = 10;
            } else {
                --this.queenCanWorkCooldown;
            }
            return this.queenCanWorkCached;
        }
    }
}

