/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.fluids.FluidHelper;
import forestry.core.gadgets.BlockForestry;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IAccessHandler;
import forestry.core.interfaces.ISocketable;
import forestry.core.items.ItemNBTTile;
import forestry.core.proxy.Proxies;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockBase
extends BlockForestry {
    private final List<MachineDefinition> definitions = new ArrayList<MachineDefinition>();
    private final boolean hasTESR;

    public BlockBase(Material material) {
        this(material, false);
    }

    public BlockBase(Material material, boolean hasTESR) {
        super(material);
        this.hasTESR = hasTESR;
    }

    public MachineDefinition addDefinition(MachineDefinition definition) {
        definition.setBlock((Block)this);
        while (this.definitions.size() <= definition.getMeta()) {
            this.definitions.add(null);
        }
        this.definitions.set(definition.getMeta(), definition);
        return definition;
    }

    public boolean isOpaqueCube() {
        return !this.hasTESR;
    }

    public boolean renderAsNormalBlock() {
        return !this.hasTESR;
    }

    public int getRenderType() {
        if (this.hasTESR) {
            return Proxies.common.getByBlockModelId();
        }
        return 0;
    }

    private MachineDefinition getDefinition(IBlockAccess world, int x, int y, int z) {
        return this.getDefinition(world.getBlockMetadata(x, y, z));
    }

    private MachineDefinition getDefinition(int metadata) {
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            return this.definitions.get(0);
        }
        return this.definitions.get(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (MachineDefinition definition : this.definitions) {
            if (definition == null) continue;
            definition.getSubBlocks(item, tab, list);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        MachineDefinition definition;
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        if ((definition = this.definitions.get(metadata)) == null) {
            return null;
        }
        return definition.createMachine();
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        MachineDefinition definition = this.getDefinition(world, x, y, z);
        return definition != null && definition.isSolidOnSide(world, x, y, z, side.ordinal());
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        super.onBlockPlacedBy(world, x, y, z, entityLiving, stack);
        TileForestry tile = (TileForestry)world.getTileEntity(x, y, z);
        if (stack.getItem() instanceof ItemNBTTile && stack.hasTagCompound()) {
            tile.readFromNBT(stack.getTagCompound());
            tile.xCoord = x;
            tile.yCoord = y;
            tile.zCoord = z;
        }
        tile.rotateAfterPlacement(entityLiving);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        if (this.getDefinition((IBlockAccess)world, x, y, z).onBlockActivated(world, x, y, z, player, side)) {
            return true;
        }
        if (player.isSneaking()) {
            return false;
        }
        TileBase tile = (TileBase)world.getTileEntity(x, y, z);
        if (!Utils.isUseableByPlayer(player, tile)) {
            return false;
        }
        IAccessHandler access = tile.getAccessHandler();
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() != Items.bucket && tile instanceof IFluidHandler && access.allowsAlteration(player) && FluidHelper.handleRightClick((IFluidHandler)tile, ForgeDirection.getOrientation((int)side), player, true, tile.canDrainWithBucket())) {
            return true;
        }
        if (!Proxies.common.isSimulating(world)) {
            return true;
        }
        if (access.allowsViewing(player)) {
            tile.openGui(player);
        } else {
            player.addChatMessage((IChatComponent)new ChatComponentTranslation("for.chat.accesslocked", new Object[]{PlayerUtil.getOwnerName(access)}));
        }
        return true;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return this.getDefinition((IBlockAccess)world, x, y, z).rotateBlock(world, x, y, z, axis);
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            Utils.dropInventory(inventory, world, x, y, z);
            if (tile instanceof TileForestry) {
                ((TileForestry)tile).onRemoval();
            }
            if (tile instanceof ISocketable) {
                Utils.dropSockets((ISocketable)tile, tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord);
            }
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public int damageDropped(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        for (MachineDefinition def : this.definitions) {
            if (def == null) continue;
            def.registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            return null;
        }
        return this.definitions.get(metadata).getBlockTextureForSide(side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata >= this.definitions.size() || this.definitions.get(metadata) == null) {
            metadata = 0;
        }
        return this.definitions.get(metadata).getIcon(world, x, y, z, side);
    }

    public boolean getUseNeighborBrightness() {
        return this.hasTESR;
    }
}

