/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.vect.MutableVect;
import forestry.core.vect.Vect;
import forestry.core.vect.VectUtil;
import forestry.farming.logic.FarmLogic;
import forestry.farming.logic.FarmableCocoa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FarmLogicCocoa
extends FarmLogic {
    private final IFarmable cocoa = new FarmableCocoa();
    private final HashMap<Vect, Integer> lastExtentsCultivation = new HashMap();
    private final HashMap<Vect, Integer> lastExtentsHarvest = new HashMap();

    public FarmLogicCocoa(IFarmHousing housing) {
        super(housing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Items.dye.getIconFromDamage(3);
    }

    @Override
    public String getName() {
        return "Cocoa Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 120;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return this.cocoa.isGermling(itemstack);
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        int lastExtent;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtentsCultivation.containsKey(start)) {
            this.lastExtentsCultivation.put(start, 0);
        }
        if ((lastExtent = this.lastExtentsCultivation.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        boolean result = this.tryPlantingCocoa(position);
        this.lastExtentsCultivation.put(start, ++lastExtent);
        return result;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        int lastExtent;
        Vect start = new Vect(x, y, z);
        if (!this.lastExtentsHarvest.containsKey(start)) {
            this.lastExtentsHarvest.put(start, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtentsHarvest.put(start, ++lastExtent);
        return crops;
    }

    private boolean tryPlantingCocoa(Vect position) {
        World world = this.getWorld();
        MutableVect current = new MutableVect(position);
        while (VectUtil.isWoodBlock(world, current) && BlockLog.func_150165_c((int)VectUtil.getBlockMeta(world, current)) == 3) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                Vect candidate;
                if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN || !VectUtil.isAirBlock(world, candidate = new Vect(current.x + direction.offsetX, current.y, current.z + direction.offsetZ))) continue;
                return this.housing.plantGermling(this.cocoa, world, candidate.x, candidate.y, candidate.z);
            }
            ++current.y;
            if (current.y - position.y <= 1) continue;
            break;
        }
        return false;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        HashSet<Vect> seen = new HashSet<Vect>();
        Stack<ICrop> crops = new Stack<ICrop>();
        Block block = VectUtil.getBlock(this.getWorld(), position);
        ICrop crop = null;
        if (!block.isWood((IBlockAccess)this.getWorld(), position.x, position.y, position.z) && (crop = this.cocoa.getCropAt(this.getWorld(), position.x, position.y, position.z)) == null) {
            return crops;
        }
        if (crop != null) {
            crops.add(crop);
        }
        ArrayList<Vect> candidates = this.processHarvestBlock(crops, seen, position, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList<Vect> processHarvestBlock(Stack<ICrop> crops, Set<Vect> seen, Vect start, Vect position) {
        World world = this.getWorld();
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    Vect candidate = position.add(i, j, k);
                    if (candidate.equals(position) || Math.abs(candidate.x - start.x) > 5 || Math.abs(candidate.z - start.z) > 5 || seen.contains(candidate)) continue;
                    ICrop crop = this.cocoa.getCropAt(world, candidate.x, candidate.y, candidate.z);
                    if (crop != null) {
                        crops.push(crop);
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!VectUtil.isWoodBlock(world, candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }
}

