/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ICrafter;
import forestry.core.interfaces.ICraftingPlan;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.GuiUtil;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.core.utils.StackUtils;
import forestry.factory.recipes.FabricatorRecipe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineFabricator
extends TilePowered
implements ICrafter,
ILiquidTankContainer,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    public static final short SLOT_METAL = 0;
    public static final short SLOT_PLAN = 1;
    public static final short SLOT_RESULT = 2;
    public static final short SLOT_CRAFTING_LEGACY_1 = 3;
    public static final short SLOT_CRAFTING_LEGACY_COUNT = 9;
    public static final short SLOT_INVENTORY_1 = 12;
    public static final short SLOT_INVENTORY_COUNT = 18;
    public static final short SLOT_COUNT = 30;
    public static final short SLOT_CRAFTING_1 = 0;
    public static final short SLOT_CRAFTING_COUNT = 9;
    private final TileInventoryAdapter craftingInventory = new TileInventoryAdapter<MachineFabricator>(this, 9, "CraftItems");
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int guiMeltingPoint = 0;

    public MachineFabricator() {
        super(1100, 50, 3300);
        this.setInternalInventory(new FabricatorInventoryAdapter(this));
        this.moltenTank = new FilteredTank(2000, Fluids.GLASS.getFluid());
        this.moltenTank.tankMode = StandardTank.TankMode.INTERNAL;
        this.tankManager = new TankManager(this.moltenTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.FabricatorGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("Heat", this.heat);
        this.tankManager.writeTanksToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.heat = nbttagcompound.getInteger("Heat");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        IInventoryAdapter inventory = this.getInternalInventory();
        for (int slot = 3; slot < 12; ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack == null) continue;
            inventory.setInventorySlotContents(slot, null);
            int newSlot = slot - 3;
            this.craftingInventory.setInventorySlotContents(newSlot, stack);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void updateServerSide() {
        Smelting smelt;
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && (smelt = RecipeManager.findMatchingSmelting(this.moltenTank.getFluid())) != null && this.heat < smelt.meltingPoint) {
            this.moltenTank.drain(5, true);
        }
        this.dissipateHeat();
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.getStackInSlot(0);
        if (smeltResource == null) {
            return;
        }
        Smelting smelt = RecipeManager.findMatchingSmelting(smeltResource);
        if (smelt == null || smelt.meltingPoint > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.fill(smeltFluid, false) == smeltFluid.amount) {
            this.decrStackSize(0, 1);
            this.moltenTank.fill(smeltFluid, true);
        }
    }

    @Override
    public boolean workCycle() {
        this.craftResult(null);
        return this.addHeat(25);
    }

    private boolean addHeat(int addition) {
        if (this.heat >= 5000) {
            return false;
        }
        this.heat += addition;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        return true;
    }

    private void dissipateHeat() {
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private IFabricatorRecipe getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.getStackInSlot(1);
        ItemStack[] crafting = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        return RecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), crafting);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack getResult() {
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.getCraftingResult((IInventory)this.craftingInventory);
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex != 2) {
            return null;
        }
        return this.getInternalInventory().decrStackSize(2, 1);
    }

    private void craftResult(EntityPlayer player) {
        Item planItem;
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return;
        }
        ItemStack result = this.getResult();
        if (result == null) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(2) != null) {
            return;
        }
        FluidStack liquid = myRecipe.getLiquid();
        ItemStack[] crafting = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        if (!this.removeFromInventory(crafting, player, false)) {
            return;
        }
        FluidStack canDrain = this.moltenTank.drain(liquid.amount, false);
        if (canDrain == null || !canDrain.isFluidStackIdentical(liquid)) {
            return;
        }
        this.removeFromInventory(crafting, player, true);
        this.moltenTank.drain(liquid.amount, true);
        if (inventory.getStackInSlot(1) != null && (planItem = inventory.getStackInSlot(1).getItem()) instanceof ICraftingPlan) {
            inventory.setInventorySlotContents(1, ((ICraftingPlan)planItem).planUsed(inventory.getStackInSlot(1), result));
        }
        inventory.setInventorySlotContents(2, result);
    }

    private boolean removeFromInventory(ItemStack[] set, EntityPlayer player, boolean doRemove) {
        IInventoryAdapter inventory = this.getInternalInventory();
        if (doRemove) {
            return InvTools.removeSets((IInventory)inventory, 1, set, 12, 18, player, true, true);
        }
        ItemStack[] stock = InvTools.getStacks((IInventory)inventory, 12, 18);
        return StackUtils.containsSets(set, stock) >= 1;
    }

    @Override
    public boolean isWorking() {
        return this.heat <= 5000;
    }

    @Override
    public boolean hasWork() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack itemToMelt = inventory.getStackInSlot(0);
        Smelting smelting = RecipeManager.findMatchingSmelting(itemToMelt);
        if (smelting != null && this.moltenTank.fill(smelting.getProduct(), false) > 0) {
            return true;
        }
        ItemStack plan = inventory.getStackInSlot(1);
        ItemStack[] resources = InvTools.getStacks((IInventory)this.craftingInventory, 0, 9);
        return RecipeManager.findMatchingRecipe(plan, this.moltenTank.getFluid(), resources) != null;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        Smelting smelt;
        if (this.moltenTank.getFluidAmount() > 0) {
            Smelting smelt2 = RecipeManager.findMatchingSmelting(this.moltenTank.getFluid());
            if (smelt2 != null) {
                return smelt2.meltingPoint;
            }
        } else if (this.getStackInSlot(0) != null && (smelt = RecipeManager.findMatchingSmelting(this.getStackInSlot(0))) != null) {
            return smelt.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        if (this.guiMeltingPoint > 0) {
            return this.guiMeltingPoint * i / 5000;
        }
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        int messageId = this.tankManager.maxMessageId() + 1;
        if (i == messageId) {
            this.heat = j;
        } else if (i == messageId + 1) {
            this.guiMeltingPoint = j;
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int messageId = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, messageId, this.heat);
        iCrafting.sendProgressBarUpdate(container, messageId + 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    public static class RecipeManager
    implements IFabricatorManager {
        public static final List<IFabricatorRecipe> recipes = new ArrayList<IFabricatorRecipe>();
        public static final List<Smelting> smeltings = new ArrayList<Smelting>();

        @Override
        public void addRecipe(IFabricatorRecipe recipe) {
            recipes.add(recipe);
        }

        @Override
        public void addRecipe(ItemStack plan, FluidStack molten, ItemStack result, Object[] pattern) {
            FabricatorRecipe recipe = new FabricatorRecipe(plan, molten, ShapedRecipeCustom.createShapedRecipe(result, pattern));
            this.addRecipe(recipe);
        }

        @Override
        public void addSmelting(ItemStack resource, FluidStack molten, int meltingPoint) {
            if (resource == null || molten == null) {
                return;
            }
            smeltings.add(new Smelting(resource, molten, meltingPoint));
        }

        public static IFabricatorRecipe findMatchingRecipe(ItemStack plan, FluidStack liquid, ItemStack[] resources) {
            ItemStack[][] gridResources = new ItemStack[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    gridResources[j][i] = resources[i * 3 + j];
                }
            }
            for (IFabricatorRecipe recipe : recipes) {
                if (!recipe.matches(plan, gridResources) || liquid != null && !liquid.containsFluid(recipe.getLiquid())) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isPlan(ItemStack plan) {
            for (IFabricatorRecipe recipe : recipes) {
                if (!StackUtils.isIdenticalItem(recipe.getPlan(), plan)) continue;
                return true;
            }
            return false;
        }

        public static Smelting findMatchingSmelting(ItemStack resource) {
            if (resource == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!StackUtils.isCraftingEquivalent(smelting.resource, resource)) continue;
                return smelting;
            }
            return null;
        }

        public static Smelting findMatchingSmelting(FluidStack product) {
            if (product == null) {
                return null;
            }
            for (Smelting smelting : smeltings) {
                if (!smelting.matches(product)) continue;
                return smelting;
            }
            return null;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (IFabricatorRecipe recipe : recipes) {
                recipeList.put(recipe.getIngredients(), new Object[]{recipe.getRecipeOutput()});
            }
            return recipeList;
        }
    }

    public static class Smelting {
        private final ItemStack resource;
        private final FluidStack product;
        private final int meltingPoint;

        public Smelting(ItemStack resource, FluidStack molten, int meltingPoint) {
            if (resource == null) {
                throw new IllegalArgumentException("Resource cannot be null");
            }
            if (molten == null) {
                throw new IllegalArgumentException("Molten cannot be null");
            }
            this.resource = resource;
            this.product = molten;
            this.meltingPoint = meltingPoint;
        }

        public boolean matches(FluidStack product) {
            return this.product.isFluidEqual(product);
        }

        public ItemStack getResource() {
            return this.resource;
        }

        public FluidStack getProduct() {
            return this.product;
        }

        public int getMeltingPoint() {
            return this.meltingPoint;
        }
    }

    private static class FabricatorInventoryAdapter
    extends TileInventoryAdapter<MachineFabricator> {
        public FabricatorInventoryAdapter(MachineFabricator fabricator) {
            super(fabricator, 30, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return RecipeManager.findMatchingSmelting(itemStack) != null;
            }
            if (slotIndex == 1) {
                return RecipeManager.isPlan(itemStack);
            }
            if (GuiUtil.isIndexInRange(slotIndex, 12, 18)) {
                if (RecipeManager.isPlan(itemStack)) {
                    return false;
                }
                if (RecipeManager.findMatchingSmelting(itemStack) != null) {
                    return false;
                }
            }
            return GuiUtil.isIndexInRange(slotIndex, 12, 18);
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack stack, int side) {
            return slotIndex == 2;
        }
    }
}

