/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IStillManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineStill
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_PRODUCT = 0;
    public static final short SLOT_RESOURCE = 1;
    public static final short SLOT_CAN = 2;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    private Recipe currentRecipe;
    private FluidStack bufferedLiquid;
    private int distillationTime = 0;
    private int distillationTotalTime = 0;

    public MachineStill() {
        super(1100, 50, 8000);
        this.setInternalInventory(new StillInventoryAdapter(this));
        this.setHints(Config.hints.get("still"));
        this.resourceTank = new FilteredTank(10000, RecipeManager.recipeFluidInputs);
        this.resourceTank.tankMode = StandardTank.TankMode.INPUT;
        this.productTank = new FilteredTank(10000, RecipeManager.recipeFluidOutputs);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this.resourceTank, this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("DistillationTime", this.distillationTime);
        nbttagcompound.setInteger("DistillationTotalTime", this.distillationTotalTime);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.distillationTime = nbttagcompound.getInteger("DistillationTime");
        this.distillationTotalTime = nbttagcompound.getInteger("DistillationTotalTime");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public void updateServerSide() {
        FluidStack fluidStack;
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.getStackInSlot(2) != null) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)inventory, 2);
        }
        if (inventory.getStackInSlot(1) != null && (fluidStack = this.productTank.getFluid()) != null) {
            FluidHelper.fillContainers(this.tankManager, (IInventory)inventory, 1, 0, fluidStack.getFluid());
        }
        this.checkRecipe();
    }

    @Override
    public boolean workCycle() {
        IErrorLogic errorLogic = this.getErrorLogic();
        this.checkRecipe();
        if (this.distillationTime > 0 && !errorLogic.hasErrors()) {
            this.distillationTime -= this.currentRecipe.input.amount;
            this.productTank.fill(this.currentRecipe.output, true);
            return true;
        }
        if (this.currentRecipe != null) {
            int resourceRequired = this.currentRecipe.timePerUnit * this.currentRecipe.input.amount;
            boolean canFill = this.productTank.fill(this.currentRecipe.output, false) == this.currentRecipe.output.amount;
            errorLogic.setCondition(!canFill, EnumErrorCode.NOSPACETANK);
            boolean hasResource = this.resourceTank.getFluidAmount() >= resourceRequired;
            errorLogic.setCondition(!hasResource, EnumErrorCode.NORESOURCE);
            if (!errorLogic.hasErrors()) {
                this.distillationTime = this.distillationTotalTime = resourceRequired;
                this.resourceTank.drain(resourceRequired, true);
                this.bufferedLiquid = new FluidStack(this.currentRecipe.input, resourceRequired);
                return true;
            }
        }
        this.bufferedLiquid = null;
        return false;
    }

    private void checkRecipe() {
        Recipe matchingRecipe = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid());
        if (matchingRecipe == null && this.bufferedLiquid != null && this.distillationTime > 0) {
            matchingRecipe = RecipeManager.findMatchingRecipe(new FluidStack(this.bufferedLiquid, this.distillationTime));
        }
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
        }
        this.getErrorLogic().setCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
    }

    @Override
    public boolean isWorking() {
        return this.distillationTime > 0 || this.currentRecipe != null && this.productTank.getFluidAmount() + this.currentRecipe.output.amount <= 10000;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        return (this.distillationTime > 0 || this.resourceTank.getFluidAmount() >= this.currentRecipe.timePerUnit * this.currentRecipe.input.amount) && this.productTank.getFluidAmount() <= this.productTank.getCapacity() - this.currentRecipe.output.amount;
    }

    public int getDistillationProgressScaled(int i) {
        if (this.distillationTotalTime == 0) {
            return i;
        }
        return this.distillationTime * i / this.distillationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.distillationTime = j;
                break;
            }
            case 1: {
                this.distillationTotalTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.sendProgressBarUpdate(container, i, this.distillationTime);
        iCrafting.sendProgressBarUpdate(container, i + 1, this.distillationTotalTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.tankManager.drain(from, quantityMax, doEmpty);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class StillInventoryAdapter
    extends TileInventoryAdapter<MachineStill> {
        public StillInventoryAdapter(MachineStill still) {
            super(still, 3, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 1) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex == 2) {
                Fluid fluid = FluidHelper.getFluidInContainer(itemStack);
                return ((MachineStill)this.tile).resourceTank.accepts(fluid);
            }
            return false;
        }

        @Override
        public boolean canExtractItem(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 0;
        }
    }

    public static class RecipeManager
    implements IStillManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        public static final HashSet<Fluid> recipeFluidInputs = new HashSet();
        public static final HashSet<Fluid> recipeFluidOutputs = new HashSet();

        @Override
        public void addRecipe(int timePerUnit, FluidStack input, FluidStack output) {
            recipes.add(new Recipe(timePerUnit, input, output));
            if (input != null) {
                recipeFluidInputs.add(input.getFluid());
            }
            if (output != null) {
                recipeFluidOutputs.add(output.getFluid());
            }
        }

        public static Recipe findMatchingRecipe(FluidStack item) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(FluidStack res) {
            return recipeFluidInputs.contains(res.getFluid());
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.input}, new Object[]{recipe.output});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerUnit;
        public final FluidStack input;
        public final FluidStack output;

        public Recipe(int timePerUnit, FluidStack input, FluidStack output) {
            this.timePerUnit = timePerUnit;
            if (input == null) {
                throw new IllegalArgumentException("Still recipes need an input. Input was null.");
            }
            if (output == null) {
                throw new IllegalArgumentException("Still recipes need an output. Output was null.");
            }
            this.input = input;
            this.output = output;
        }

        public boolean matches(FluidStack res) {
            return res != null && res.containsFluid(this.input);
        }
    }
}

