/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.INBTTagable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NaturalistGame
implements INBTTagable,
IStreamable {
    public static final int BOUNTY_MAX = 16;
    private final Random rand = new Random();
    private GameToken[] gameTokens;
    private long lastUpdate;
    private boolean isEnded;
    private int bountyLevel;

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("isEnded", this.isEnded);
        nbttagcompound.setInteger("bountyLevel", this.bountyLevel);
        nbttagcompound.setLong("lastUpdate", this.lastUpdate);
        if (this.gameTokens != null) {
            nbttagcompound.setInteger("TokenCount", this.gameTokens.length);
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.gameTokens.length; ++i) {
                if (this.gameTokens[i] == null) continue;
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setByte("Slot", (byte)i);
                this.gameTokens[i].writeToNBT(nbttagcompound2);
                nbttaglist.appendTag((NBTBase)nbttagcompound2);
            }
            nbttagcompound.setTag("GameTokens", (NBTBase)nbttaglist);
        } else {
            nbttagcompound.setInteger("TokenCount", 0);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.isEnded = nbttagcompound.getBoolean("isEnded");
        this.bountyLevel = nbttagcompound.getInteger("bountyLevel");
        this.lastUpdate = nbttagcompound.getLong("lastUpdate");
        int tokenCount = nbttagcompound.getInteger("TokenCount");
        if (tokenCount > 0) {
            this.gameTokens = new GameToken[tokenCount];
            NBTTagList nbttaglist = nbttagcompound.getTagList("GameTokens", 10);
            for (int j = 0; j < nbttaglist.tagCount(); ++j) {
                NBTTagCompound nbttagcompound2 = nbttaglist.getCompoundTagAt(j);
                byte index = nbttagcompound2.getByte("Slot");
                this.gameTokens[index] = new GameToken(nbttagcompound2);
            }
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeBoolean(this.isEnded);
        data.writeInt(this.bountyLevel);
        data.writeLong(this.lastUpdate);
        List<GameToken> gameTokensList = this.gameTokens == null ? null : Arrays.asList(this.gameTokens);
        data.writeStreamables(gameTokensList);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.isEnded = data.readBoolean();
        this.bountyLevel = data.readInt();
        this.lastUpdate = data.readLong();
        List<GameToken> gameTokensList = data.readStreamables(GameToken.class);
        if (gameTokensList != null) {
            this.gameTokens = gameTokensList.toArray(new GameToken[gameTokensList.size()]);
        }
    }

    public void initialize(ItemStack specimen) {
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return;
        }
        int boardSize = individual.getGenome().getPrimary().getComplexity() + individual.getGenome().getSecondary().getComplexity();
        if (boardSize % 2 != 0) {
            boardSize = Math.round((float)boardSize / 2.0f) * 2;
        }
        if (boardSize > 22) {
            boardSize = 22;
        } else if (boardSize < 6) {
            boardSize = 6;
        }
        this.isEnded = false;
        this.bountyLevel = 16;
        this.gameTokens = new GameToken[boardSize];
        ISpeciesRoot root = individual.getGenome().getPrimary().getRoot();
        ArrayList<ItemStack> pairs = new ArrayList<ItemStack>();
        for (int i = 0; i < boardSize / 2; ++i) {
            IIndividual token = root.templateAsIndividual(root.getRandomTemplate(this.rand));
            pairs.add(root.getMemberStack(token, 0));
        }
        boolean first = true;
        for (ItemStack pair : pairs) {
            if (first) {
                this.gameTokens[0] = new GameToken(pair.copy());
                first = false;
            } else {
                this.gameTokens[this.getFreeTokenIndex()] = new GameToken(pair.copy());
            }
            this.gameTokens[this.getFreeTokenIndex()] = new GameToken(pair.copy());
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    private int getFreeTokenIndex() {
        int probe;
        while (this.gameTokens[probe = this.rand.nextInt(this.gameTokens.length)] != null) {
        }
        return probe;
    }

    private int countUnrevealedTokens() {
        int count = 0;
        for (GameToken token : this.gameTokens) {
            if (token.isRevealed) continue;
            ++count;
        }
        return count;
    }

    private int[] getUnrevealedTokens(int count) {
        ArrayList<Integer> existing = new ArrayList<Integer>();
        int remaining = this.countUnrevealedTokens();
        int[] unrevealed = new int[count < remaining ? count : remaining];
        for (int i = 0; i < unrevealed.length; ++i) {
            int found = -1;
            while (found < 0) {
                int probe = this.rand.nextInt(this.gameTokens.length);
                if (this.gameTokens[probe].isRevealed) continue;
                boolean taken = false;
                Iterator i$ = existing.iterator();
                while (i$.hasNext()) {
                    int exist = (Integer)i$.next();
                    if (exist != probe) continue;
                    taken = true;
                    break;
                }
                if (taken) continue;
                existing.add(probe);
                found = probe;
            }
            unrevealed[i] = found;
        }
        return unrevealed;
    }

    public void probe(ItemStack specimen, IInventory inventory, int startSlot, int slotCount) {
        if (this.gameTokens == null) {
            return;
        }
        if (this.isEnded) {
            return;
        }
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return;
        }
        this.hideProbedTokens();
        if (this.bountyLevel > 1) {
            --this.bountyLevel;
        }
        int[] tokenIndices = this.getUnrevealedTokens(this.getSampleSize() <= slotCount ? this.getSampleSize() : slotCount);
        int processedTokens = 0;
        for (int i = 0; i < slotCount; ++i) {
            ItemStack sample = inventory.getStackInSlot(startSlot + i);
            if (sample == null || sample.stackSize <= 0) continue;
            sample = inventory.decrStackSize(startSlot + i, 1);
            if (this.rand.nextFloat() >= individual.getGenome().getPrimary().getResearchSuitability(sample)) continue;
            GameToken token = this.gameTokens[tokenIndices[processedTokens]];
            token.isProbed = true;
            token.isRevealed = true;
            if (++processedTokens >= tokenIndices.length) break;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void choose(int tokenIndex) {
        if (this.isEnded) {
            return;
        }
        if (this.gameTokens == null || tokenIndex >= this.gameTokens.length) {
            return;
        }
        GameToken token = this.gameTokens[tokenIndex];
        if (token.isRevealed && !token.isProbed) {
            return;
        }
        this.hideProbedTokens();
        Collection<GameToken> singles = this.getRevealedSingles(token);
        if (singles.size() > 0) {
            boolean matched = false;
            for (GameToken single : singles) {
                if (!single.matches(token)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                token.isFailed = true;
            }
        }
        token.isRevealed = true;
        this.checkGameEnd();
        this.lastUpdate = System.currentTimeMillis();
    }

    public void reset() {
        this.gameTokens = null;
        this.lastUpdate = System.currentTimeMillis();
    }

    public boolean isInited() {
        return this.gameTokens != null;
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getBountyLevel() {
        return this.bountyLevel;
    }

    public boolean isWon() {
        if (!this.isEnded) {
            return false;
        }
        return !this.isLost();
    }

    private void checkGameEnd() {
        if (this.isLost()) {
            this.isEnded = true;
        }
        if (this.isRevealed()) {
            this.isEnded = true;
        }
    }

    private boolean isRevealed() {
        for (GameToken token : this.gameTokens) {
            if (token.isRevealed) continue;
            return false;
        }
        return true;
    }

    private boolean isLost() {
        for (GameToken token : this.gameTokens) {
            if (!token.isFailed) continue;
            return true;
        }
        return false;
    }

    private void hideProbedTokens() {
        for (GameToken token : this.gameTokens) {
            if (!token.isProbed) continue;
            token.isRevealed = false;
            token.isProbed = false;
        }
    }

    private Collection<GameToken> getRevealedSingles(GameToken exclude) {
        ArrayList<GameToken> singles = new ArrayList<GameToken>();
        for (GameToken token : this.gameTokens) {
            if (!token.isRevealed || token == exclude) continue;
            GameToken matching = null;
            for (GameToken single : singles) {
                if (!single.matches(token)) continue;
                matching = single;
                break;
            }
            if (matching == null) {
                singles.add(token);
                continue;
            }
            singles.remove(matching);
        }
        return singles;
    }

    public int getSampleSize() {
        if (this.gameTokens == null) {
            return 0;
        }
        int samples = this.gameTokens.length / 4;
        return Math.max(samples, 2);
    }

    public GameToken getToken(int index) {
        if (this.gameTokens != null && index < this.gameTokens.length) {
            return this.gameTokens[index];
        }
        return null;
    }

    public static class GameToken
    implements INBTTagable,
    IStreamable {
        private static final String[] OVERLAY_NONE = new String[0];
        private static final String[] OVERLAY_FAILED = new String[]{"errors/errored"};
        public ItemStack tokenStack;
        protected boolean isFailed = false;
        protected boolean isProbed = false;
        protected boolean isRevealed = false;

        public GameToken() {
        }

        public GameToken(ItemStack tokenStack) {
            this.tokenStack = tokenStack;
        }

        public GameToken(NBTTagCompound nbttagcompound) {
            this.readFromNBT(nbttagcompound);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.isFailed = nbttagcompound.getBoolean("isFailed");
            this.isProbed = nbttagcompound.getBoolean("isProbed");
            this.isRevealed = nbttagcompound.getBoolean("isRevealed");
            if (nbttagcompound.hasKey("tokenStack")) {
                this.tokenStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound.getCompoundTag("tokenStack"));
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            nbttagcompound.setBoolean("isFailed", this.isFailed);
            nbttagcompound.setBoolean("isProbed", this.isProbed);
            nbttagcompound.setBoolean("isRevealed", this.isRevealed);
            if (this.tokenStack != null) {
                NBTTagCompound stackcompound = new NBTTagCompound();
                this.tokenStack.writeToNBT(stackcompound);
                nbttagcompound.setTag("tokenStack", (NBTBase)stackcompound);
            }
        }

        @Override
        public void writeData(DataOutputStreamForestry data) throws IOException {
            data.writeBoolean(this.isFailed);
            data.writeBoolean(this.isProbed);
            data.writeBoolean(this.isRevealed);
            data.writeItemStack(this.tokenStack);
        }

        @Override
        public void readData(DataInputStreamForestry data) throws IOException {
            this.isFailed = data.readBoolean();
            this.isProbed = data.readBoolean();
            this.isRevealed = data.readBoolean();
            this.tokenStack = data.readItemStack();
        }

        public boolean isVisible() {
            return this.isRevealed;
        }

        public int getTokenColour() {
            if (this.tokenStack == null || !this.isVisible()) {
                return 0xFFFFFF;
            }
            if (this.isProbed) {
                return Utils.multiplyRGBComponents(AlleleManager.alleleRegistry.getIndividual(this.tokenStack).getGenome().getPrimary().getIconColour(0), 0.7f);
            }
            return AlleleManager.alleleRegistry.getIndividual(this.tokenStack).getGenome().getPrimary().getIconColour(0);
        }

        public String getTooltip() {
            return this.tokenStack != null ? this.tokenStack.getDisplayName() : StringUtil.localize("gui.unknown");
        }

        public String[] getOverlayIcons() {
            return this.isFailed ? OVERLAY_FAILED : OVERLAY_NONE;
        }

        public boolean matches(GameToken other) {
            return this.tokenStack.isItemEqual(other.tokenStack) && ItemStack.areItemStackTagsEqual((ItemStack)this.tokenStack, (ItemStack)other.tokenStack);
        }
    }
}

