/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.farming.DefaultFarmListener;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.core.vect.Vect;
import forestry.farming.multiblock.TileFarm;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileControl
extends TileFarm
implements IFarmComponent.Listener {
    private final IFarmListener farmListener = new ControlFarmListener(this);

    @Override
    public IFarmListener getFarmListener() {
        return this.farmListener;
    }

    private static class ControlFarmListener
    extends DefaultFarmListener {
        private final TileControl tile;

        public ControlFarmListener(TileControl tile) {
            this.tile = tile;
        }

        @Override
        public boolean cancelTask(IFarmLogic logic, FarmDirection direction) {
            return this.hasRedstoneSignal(direction.getForgeDirection()) || this.hasRedstoneSignal(ForgeDirection.UP) || this.hasRedstoneSignal(ForgeDirection.DOWN);
        }

        private boolean hasRedstoneSignal(ForgeDirection direction) {
            Vect side = new Vect(this.tile).add(direction);
            int dir = direction.getOpposite().ordinal();
            World world = this.tile.getWorldObj();
            return world.getIndirectPowerLevelTo(side.x, side.y, side.z, dir) > 0 || world.isBlockProvidingPowerTo(side.x, side.y, side.z, dir) > 0;
        }
    }
}

