/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.interfaces.ISocketable;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.plugins.PluginIC2;
import ic2.api.energy.prefab.BasicSink;
import ic2.api.item.ElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EngineTin
extends Engine
implements ISocketable,
IInventory {
    public static final short SLOT_BATTERY = 0;
    private final InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private final EuConfig euConfig = new EuConfig();
    private BasicSink ic2EnergySink;

    public EngineTin() {
        super(3000, 100000);
        this.setHints(Config.hints.get("engine.tin"));
        this.setInternalInventory(new EngineTinInventoryAdapter(this));
        if (PluginIC2.instance.isAvailable()) {
            this.ic2EnergySink = new BasicSink((TileEntity)this, this.euConfig.euStorage, 3);
        }
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.EngineTinGUI.ordinal(), player.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.readFromNBT(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.readFromNBT(nbttagcompound);
        }
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.getStackInSlot(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.writeToNBT(nbttagcompound);
        }
        this.sockets.writeToNBT(nbttagcompound);
    }

    public void onChunkUnload() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.onChunkUnload();
        }
        super.onChunkUnload();
    }

    @Override
    public void invalidate() {
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.invalidate();
        }
        super.invalidate();
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.isRedstoneActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.isRedstoneActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.energyManager.getTotalEnergyStored() / (double)this.maxEnergy > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void updateServerSide() {
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition(this.ic2EnergySink == null, EnumErrorCode.NOENERGYNET)) {
            return;
        }
        this.ic2EnergySink.updateEntity();
        super.updateServerSide();
        if (this.forceCooldown) {
            return;
        }
        if (this.getInternalInventory().getStackInSlot(0) != null) {
            this.replenishFromBattery(0);
        }
        if (!this.updateOnInterval(80)) {
            return;
        }
        boolean canUseEnergy = this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
        errorLogic.setCondition(!canUseEnergy, EnumErrorCode.NOFUEL);
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (!this.isRedstoneActivated()) {
            return;
        }
        if (this.ic2EnergySink.useEnergy((double)this.euConfig.euForCycle)) {
            this.currentOutput = this.euConfig.rfPerCycle;
            this.energyManager.generateEnergy(this.euConfig.rfPerCycle);
        }
    }

    private void replenishFromBattery(int slot) {
        if (!this.isRedstoneActivated()) {
            return;
        }
        this.ic2EnergySink.discharge(this.getInternalInventory().getStackInSlot(slot), this.euConfig.euForCycle * 3);
    }

    @Override
    protected boolean isBurning() {
        return this.mayBurn() && this.ic2EnergySink != null && this.ic2EnergySink.canUseEnergy((double)this.euConfig.euForCycle);
    }

    public int getStorageScaled(int i) {
        if (this.ic2EnergySink == null) {
            return 0;
        }
        return Math.min(i, (int)(this.ic2EnergySink.getEnergyStored() * (double)i) / this.ic2EnergySink.getCapacity());
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.currentOutput = j;
                break;
            }
            case 1: {
                this.energyManager.fromGuiInt(j);
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                if (this.ic2EnergySink == null) break;
                this.ic2EnergySink.setEnergyStored((double)j);
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(containerEngine, 0, this.currentOutput);
        iCrafting.sendProgressBarUpdate(containerEngine, 1, this.energyManager.toGuiInt());
        iCrafting.sendProgressBarUpdate(containerEngine, 2, this.heat);
        if (this.ic2EnergySink != null) {
            iCrafting.sendProgressBarUpdate(containerEngine, 3, (int)((short)this.ic2EnergySink.getEnergyStored()));
        }
    }

    public void changeEnergyConfig(int euChange, int rfChange, int storageChange) {
        this.euConfig.euForCycle += euChange;
        this.euConfig.rfPerCycle += rfChange;
        this.euConfig.euStorage += storageChange;
        if (this.ic2EnergySink != null) {
            this.ic2EnergySink.setCapacity(this.euConfig.euStorage);
        }
    }

    @Override
    public int getSocketCount() {
        return this.sockets.getSizeInventory();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.getStackInSlot(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.getStackInSlot(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.getStackInSlot(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.getStackInSlot(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.setInventorySlotContents(slot, stack);
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    private static class EngineTinInventoryAdapter
    extends TileInventoryAdapter<EngineTin> {
        public EngineTinInventoryAdapter(EngineTin engineTin) {
            super(engineTin, 1, "electrical");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 0) {
                return ElectricItem.manager.getCharge(itemStack) > 0.0;
            }
            return false;
        }
    }

    protected static class EuConfig {
        public int euForCycle = 5;
        public int rfPerCycle = 20;
        public int euStorage = 10;
    }
}

