/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.world.World;

public class WorldGenSequoia
extends WorldGenTree {
    public WorldGenSequoia(ITreeGenData tree) {
        this(tree, 20, 5);
    }

    protected WorldGenSequoia(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree, baseHeight, heightVariation);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int topLength = this.height / 4;
        int topHeight = this.height - topLength + world.rand.nextInt(this.height / 4);
        int leafSpawn = this.height + 2;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        while (leafSpawn > topHeight) {
            this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = this.height / 3 + world.rand.nextInt(this.height - this.height / 3);
            if (world.rand.nextBoolean() && h < this.height / 3) {
                h = this.height / 2 + world.rand.nextInt(this.height / 3);
            }
            int x_off = -1 + world.rand.nextInt(3);
            int y_off = -1 + world.rand.nextInt(3);
            WorldGenBase.Vector center = new WorldGenBase.Vector(x_off, h, y_off);
            int radius = 1 + world.rand.nextInt(2);
            this.generateSphere(world, center, radius, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }
}

