/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import forestry.core.inventory.InvTools;
import forestry.core.proxy.Proxies;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtils {
    public static final ItemStack[] EMPTY_STACK_ARRAY = new ItemStack[0];

    public static boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.getItem() != rhs.getItem()) {
            return false;
        }
        if (lhs.getItemDamage() != Short.MAX_VALUE && lhs.getItemDamage() != rhs.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)lhs, (ItemStack)rhs);
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd) {
        return StackUtils.stowInInventory(itemstack, inventory, doAdd, 0, inventory.getSizeInventory());
    }

    public static boolean stowInInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.setInventorySlotContents(i, itemstack.copy());
                    itemstack.stackSize = 0;
                }
                return true;
            }
            if (inventoryStack.stackSize >= inventoryStack.getMaxStackSize() || !inventoryStack.isItemEqual(itemstack) || !ItemStack.areItemStackTagsEqual((ItemStack)inventoryStack, (ItemStack)itemstack)) continue;
            int space = inventoryStack.getMaxStackSize() - inventoryStack.stackSize;
            if (space > itemstack.stackSize) {
                if (doAdd) {
                    inventoryStack.stackSize += itemstack.stackSize;
                    itemstack.stackSize = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.stackSize = inventoryStack.getMaxStackSize();
                itemstack.stackSize -= space;
            }
            added = true;
        }
        return added;
    }

    public static int addToInventory(ItemStack itemstack, IInventory inventory, boolean doAdd, int slot1, int count) {
        int added = 0;
        for (int i = slot1; i < slot1 + count; ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.setInventorySlotContents(i, itemstack.copy());
                }
                return itemstack.stackSize;
            }
            if (inventoryStack.stackSize >= inventoryStack.getMaxStackSize() || !inventoryStack.isItemEqual(itemstack)) continue;
            int space = inventoryStack.getMaxStackSize() - inventoryStack.stackSize;
            if (space > itemstack.stackSize - added) {
                if (doAdd) {
                    inventoryStack.stackSize += itemstack.stackSize;
                }
                return itemstack.stackSize;
            }
            if (doAdd) {
                inventoryStack.stackSize = inventoryStack.getMaxStackSize();
            }
            added += space;
        }
        return added;
    }

    public static void mergeStacks(ItemStack giver, ItemStack receptor) {
        if (receptor.stackSize >= 64) {
            return;
        }
        if (!receptor.isItemEqual(giver)) {
            return;
        }
        if (giver.stackSize <= receptor.getMaxStackSize() - receptor.stackSize) {
            receptor.stackSize += giver.stackSize;
            giver.stackSize = 0;
            return;
        }
        ItemStack temp = giver.splitStack(receptor.getMaxStackSize() - receptor.stackSize);
        receptor.stackSize += temp.stackSize;
        temp.stackSize = 0;
    }

    public static boolean freeSpaceInStack(ItemStack stack, int maxSize) {
        if (stack == null) {
            return true;
        }
        return stack.stackSize < maxSize;
    }

    public static ItemStack createSplitStack(ItemStack stack, int amount) {
        ItemStack split = new ItemStack(stack.getItem(), amount, stack.getItemDamage());
        if (stack.getTagCompound() != null) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)stack.getTagCompound().copy();
            split.setTagCompound(nbttagcompound);
        }
        return split;
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks) {
        return StackUtils.condenseStacks(stacks, -1, false);
    }

    public static ItemStack[] condenseStacks(ItemStack[] stacks, int maxCountedPerStack, boolean craftingEquivalency) {
        ArrayList<ItemStack> condensed = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack == null || stack.stackSize <= 0) continue;
            boolean matched = false;
            for (ItemStack cached : condensed) {
                if ((!cached.isItemEqual(stack) || !ItemStack.areItemStackTagsEqual((ItemStack)cached, (ItemStack)stack)) && (!craftingEquivalency || !StackUtils.isCraftingEquivalent(cached, stack, true, false))) continue;
                cached.stackSize = cached.stackSize + (maxCountedPerStack > 0 && stack.stackSize > maxCountedPerStack ? maxCountedPerStack : stack.stackSize);
                matched = true;
            }
            if (matched) continue;
            ItemStack cached = stack.copy();
            if (maxCountedPerStack > 0) {
                cached.stackSize = maxCountedPerStack;
            }
            condensed.add(cached);
        }
        return condensed.toArray(new ItemStack[condensed.size()]);
    }

    public static boolean containsItemStack(Iterable<ItemStack> list, ItemStack itemStack) {
        for (ItemStack listStack : list) {
            if (!StackUtils.isIdenticalItem(listStack, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock) {
        return StackUtils.containsSets(set, stock, false, false);
    }

    public static int containsSets(ItemStack[] set, ItemStack[] stock, boolean oreDictionary, boolean craftingTools) {
        int count = 0;
        ItemStack[] condensedRequired = StackUtils.condenseStacks(set, -1, oreDictionary);
        ItemStack[] condensedOffered = StackUtils.condenseStacks(stock, -1, oreDictionary);
        for (ItemStack req : condensedRequired) {
            boolean matched = false;
            for (ItemStack offer : condensedOffered) {
                if (!StackUtils.isCraftingEquivalent(req, offer, oreDictionary, craftingTools)) continue;
                int stackCount = (int)Math.floor(offer.stackSize / req.stackSize);
                matched |= stackCount > 0;
                if (count == 0) {
                    count = stackCount;
                    continue;
                }
                if (count <= stackCount) continue;
                count = stackCount;
            }
            if (matched) continue;
            return 0;
        }
        return count;
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.getItem() != comparison.getItem()) {
            return false;
        }
        if (base.getItemDamage() != Short.MAX_VALUE && base.getItemDamage() != comparison.getItemDamage()) {
            return false;
        }
        if (base.stackTagCompound == null || base.stackTagCompound.hasNoTags()) {
            return true;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)base, (ItemStack)comparison);
    }

    public static boolean isCraftingEquivalent(ItemStack base, ItemStack comparison, boolean oreDictionary, boolean craftingTools) {
        if (StackUtils.isCraftingEquivalent(base, comparison)) {
            return true;
        }
        if (base == null || comparison == null) {
            return false;
        }
        if (base.hasTagCompound() && !base.stackTagCompound.hasNoTags() && !ItemStack.areItemStacksEqual((ItemStack)base, (ItemStack)comparison)) {
            return false;
        }
        if (oreDictionary) {
            int[] idsBase = OreDictionary.getOreIDs((ItemStack)base);
            Arrays.sort(idsBase);
            int[] idsComp = OreDictionary.getOreIDs((ItemStack)comparison);
            Arrays.sort(idsComp);
            int iBase = 0;
            int iComp = 0;
            while (iBase < idsBase.length && iComp < idsComp.length) {
                if (idsBase[iBase] < idsComp[iComp]) {
                    ++iBase;
                    continue;
                }
                if (idsBase[iBase] > idsComp[iComp]) {
                    ++iComp;
                    continue;
                }
                return true;
            }
        }
        if (craftingTools) {
            return StackUtils.isThisCraftingTool(base, comparison);
        }
        return false;
    }

    public static boolean isCraftingTool(ItemStack itemstack) {
        return itemstack.getItem().hasContainerItem(itemstack) && itemstack.getItem().isDamageable() && !itemstack.getItem().doesContainerItemLeaveCraftingGrid(itemstack);
    }

    public static boolean isThisCraftingTool(ItemStack phantom, ItemStack actual) {
        return StackUtils.isCraftingTool(phantom) && phantom.getItem() == actual.getItem();
    }

    public static void stowContainerItem(ItemStack itemstack, IInventory stowing, int slotIndex, EntityPlayer player) {
        if (!itemstack.getItem().hasContainerItem(itemstack)) {
            return;
        }
        ItemStack container = itemstack.getItem().getContainerItem(itemstack);
        if (container.isItemStackDamageable() && container.getItemDamage() > container.getMaxDamage()) {
            if (player != null) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
            }
            container = null;
        }
        if (container != null) {
            if (itemstack.getItem().doesContainerItemLeaveCraftingGrid(itemstack)) {
                if (!InvTools.tryAddStack(stowing, container, true) && player != null && !player.inventory.addItemStackToInventory(container)) {
                    player.dropPlayerItemWithRandomChoice(container, true);
                }
            } else if (!InvTools.tryAddStack(stowing, container, slotIndex, 1, true) && !InvTools.tryAddStack(stowing, container, true) && player != null) {
                player.dropPlayerItemWithRandomChoice(container, true);
            }
        }
    }

    public static void dropItemStackAsEntity(ItemStack items, World world, double x, double y, double z) {
        if (items.stackSize <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, items);
        entityitem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityitem);
    }

    public static ItemStack copyWithRandomSize(ItemStack template, int max, Random rand) {
        int size = rand.nextInt(max);
        ItemStack created = template.copy();
        created.stackSize = size <= 0 ? 1 : (size > created.getMaxStackSize() ? created.getMaxStackSize() : size);
        return created;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            if (stack.getItem().hasContainerItem(stack)) {
                return stack.getItem().getContainerItem(stack);
            }
            return null;
        }
        stack.splitStack(1);
        return stack;
    }

    public static Block getBlock(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static boolean equals(Block block, ItemStack stack) {
        return block == StackUtils.getBlock(stack);
    }

    public static boolean equals(Block block, int meta, ItemStack stack) {
        return block == StackUtils.getBlock(stack) && meta == stack.getItemDamage();
    }

    public static List<ItemStack> parseItemStackStrings(String[] itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = StackUtils.parseStackStrings(itemStackStrings, missingMetaValue);
        return StackUtils.getItemStacks(stacks);
    }

    public static List<ItemStack> parseItemStackStrings(String itemStackStrings, int missingMetaValue) {
        List<Stack> stacks = StackUtils.parseStackStrings(itemStackStrings, missingMetaValue);
        return StackUtils.getItemStacks(stacks);
    }

    private static List<ItemStack> getItemStacks(List<Stack> stacks) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(stacks.size());
        for (Stack stack : stacks) {
            Item item = stack.getItem();
            if (item == null) continue;
            int meta = stack.getMeta();
            ItemStack itemStack = new ItemStack(item, 1, meta);
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    public static List<Stack> parseStackStrings(String itemStackStrings, int missingMetaValue) {
        String[] parts = itemStackStrings.split("(\\s*;\\s*)+");
        return StackUtils.parseStackStrings(parts, missingMetaValue);
    }

    public static List<Stack> parseStackStrings(String[] parts, int missingMetaValue) {
        ArrayList<Stack> stacks = new ArrayList<Stack>();
        for (String itemStackString : parts) {
            Stack stack = StackUtils.parseStackString(itemStackString, missingMetaValue);
            if (stack == null) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static Stack parseStackString(String stackString, int missingMetaValue) {
        int meta;
        if (stackString == null) {
            return null;
        }
        if ((stackString = stackString.trim()).isEmpty()) {
            return null;
        }
        String[] parts = stackString.split(":+");
        if (parts.length != 2 && parts.length != 3) {
            Proxies.log.warning("Stack string (" + stackString + ") isn't formatted properly. Suitable formats are <modId>:<name>, <modId>:<name>:<meta> or <modId>:<name>:*, e.g. IC2:blockWall:*");
            return null;
        }
        String name = parts[0] + ':' + parts[1];
        if (parts.length == 2) {
            meta = missingMetaValue;
        } else {
            try {
                meta = parts[2].equals("*") ? Short.MAX_VALUE : NumberFormat.getIntegerInstance().parse(parts[2]).intValue();
            }
            catch (ParseException e) {
                Proxies.log.warning("ItemStack string (" + stackString + ") has improperly formatted metadata. Suitable metadata are integer values or *.");
                return null;
            }
        }
        return new Stack(name, meta);
    }

    public static class Stack {
        private final String name;
        private final int meta;

        public Stack(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public Item getItem() {
            Item item = (Item)GameData.getItemRegistry().getRaw(this.name);
            if (item == null) {
                Proxies.log.warning("Failed to find item for (" + this.name + ") in the Forge registry.");
            }
            return item;
        }

        public Block getBlock() {
            Block block = (Block)GameData.getBlockRegistry().getRaw(this.name);
            if (block == null) {
                Proxies.log.warning("Failed to find block for (" + this.name + ") in the Forge registry.");
            }
            return block;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

