/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.arboriculture.genetics.CheckPollinatable;
import forestry.arboriculture.genetics.CheckPollinatableTree;
import forestry.arboriculture.genetics.ICheckPollinatable;
import forestry.core.genetics.ItemGE;
import forestry.core.utils.StackUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GeneticsUtil {
    private static Set<Block> ersatzSpecimenBlocks;

    private static Set<Block> getErsatzBlocks() {
        if (ersatzSpecimenBlocks == null) {
            ersatzSpecimenBlocks = new HashSet<Block>();
            for (ItemStack ersatzSpecimen : AlleleManager.ersatzSpecimen.keySet()) {
                Block ersatzBlock = StackUtils.getBlock(ersatzSpecimen);
                if (ersatzBlock == null) continue;
                ersatzSpecimenBlocks.add(ersatzBlock);
            }
        }
        return ersatzSpecimenBlocks;
    }

    private static boolean isErsatzBlock(Block block) {
        return block != null && GeneticsUtil.getErsatzBlocks().contains(block);
    }

    public static boolean hasNaturalistEye(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack armorItemStack = player.inventory.armorInventory[3];
        if (armorItemStack == null) {
            return false;
        }
        Item armorItem = armorItemStack.getItem();
        if (!(armorItem instanceof IArmorNaturalist)) {
            return false;
        }
        IArmorNaturalist armorNaturalist = (IArmorNaturalist)armorItem;
        return armorNaturalist.canSeePollination(player, armorItemStack, true);
    }

    public static boolean canNurse(IButterfly butterfly, World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IButterflyNursery) {
            return ((IButterflyNursery)tile).canNurse(butterfly);
        }
        return GeneticsUtil.getErsatzPollen(world, x, y, z) != null;
    }

    public static ICheckPollinatable getCheckPollinatable(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IPollinatable) {
            return new CheckPollinatable((IPollinatable)tile);
        }
        ITree pollen = GeneticsUtil.getErsatzPollen(world, x, y, z);
        if (pollen != null) {
            return new CheckPollinatableTree(pollen);
        }
        return null;
    }

    public static IPollinatable getOrCreatePollinatable(GameProfile owner, World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IPollinatable) {
            return (IPollinatable)tile;
        }
        ITree pollen = GeneticsUtil.getErsatzPollen(world, x, y, z);
        if (pollen != null) {
            pollen.setLeaves(world, owner, x, y, z);
            return (IPollinatable)world.getTileEntity(x, y, z);
        }
        return null;
    }

    public static ITree getErsatzPollen(World world, int x, int y, int z) {
        ItemStack itemStack;
        IIndividual tree;
        Block block = world.getBlock(x, y, z);
        if (!GeneticsUtil.isErsatzBlock(block)) {
            return null;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (Blocks.leaves == block || Blocks.leaves2 == block) {
            if ((meta & 4) != 0) {
                return null;
            }
            if (block == Blocks.leaves2) {
                meta += 4;
            }
            block = Blocks.sapling;
        }
        if ((tree = GeneticsUtil.getGeneticEquivalent(itemStack = new ItemStack(block, 1, meta))) instanceof ITree) {
            return (ITree)tree;
        }
        return null;
    }

    public static IIndividual getGeneticEquivalent(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ItemGE) {
            return ((ItemGE)item).getIndividual(itemStack);
        }
        for (Map.Entry<ItemStack, IIndividual> entry : AlleleManager.ersatzSaplings.entrySet()) {
            if (!StackUtils.isIdenticalItem(itemStack, entry.getKey())) continue;
            return entry.getValue().copy();
        }
        return null;
    }

    public static ItemStack convertSaplingToGeneticEquivalent(ItemStack foreign) {
        IIndividual tree = GeneticsUtil.getGeneticEquivalent(foreign);
        if (!(tree instanceof ITree)) {
            return null;
        }
        ItemStack ersatz = TreeManager.treeRoot.getMemberStack(tree, EnumGermlingType.SAPLING.ordinal());
        ersatz.stackSize = foreign.stackSize;
        return ersatz;
    }

    public static int getResearchComplexity(IAlleleSpecies species, IChromosomeType speciesChromosome) {
        return 1 + GeneticsUtil.getGeneticAdvancement(species, new HashSet<IAlleleSpecies>(), speciesChromosome);
    }

    private static int getGeneticAdvancement(IAlleleSpecies species, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        int highest = 0;
        exclude.add(species);
        for (IMutation iMutation : species.getRoot().getPaths(species, speciesChromosome)) {
            int otherAdvance;
            if (!exclude.contains(iMutation.getAllele0()) && (otherAdvance = GeneticsUtil.getGeneticAdvancement(iMutation.getAllele0(), exclude, speciesChromosome)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(iMutation.getAllele1()) || (otherAdvance = GeneticsUtil.getGeneticAdvancement(iMutation.getAllele1(), exclude, speciesChromosome)) <= highest) continue;
            highest = otherAdvance;
        }
        return 1 + highest;
    }
}

