/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorSource;
import forestry.core.config.Config;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.ClimateLedger;
import forestry.core.gui.HintLedger;
import forestry.core.gui.LedgerManager;
import forestry.core.gui.OwnerLedger;
import forestry.core.gui.PowerLedger;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.gui.widgets.Widget;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.FontColour;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public abstract class GuiForestry<C extends Container, I extends IInventory>
extends GuiContainer
implements INEIGuiHandler {
    protected static final int LINE_HEIGHT = 12;
    protected final WidgetManager widgetManager = new WidgetManager(this);
    protected final LedgerManager ledgerManager = new LedgerManager(this);
    protected final I inventory;
    protected final C container;
    protected final FontColour fontColor;
    public final ResourceLocation textureFile;
    protected int column0;
    protected int column1;
    protected int column2;
    private int line;

    protected GuiForestry(String texture, C container, I inventory) {
        this(new ResourceLocation("forestry", texture), container, inventory);
    }

    protected GuiForestry(ResourceLocation texture, C container, I inventory) {
        super(container);
        this.textureFile = texture;
        this.inventory = inventory;
        this.container = container;
        this.fontColor = new FontColour(Proxies.common.getSelectedTexturePack(Proxies.common.getClientInstance()));
        this.initLedgers();
    }

    protected void initLedgers() {
        if (this.inventory instanceof IErrorSource) {
            this.ledgerManager.add((IErrorSource)this.inventory);
        }
        if (this.inventory instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.inventory;
            this.ledgerManager.add(errorLogicSource.getErrorLogic());
        }
        if (this.inventory instanceof IClimatised) {
            this.ledgerManager.add(new ClimateLedger(this.ledgerManager, (IClimatised)this.inventory));
        }
        if (Config.enableEnergyStat && this.inventory instanceof IPowerHandler && ((IPowerHandler)this.inventory).getEnergyManager().getMaxEnergyStored() > 0) {
            this.ledgerManager.add(new PowerLedger(this.ledgerManager, (IPowerHandler)this.inventory));
        }
        if (Config.enableHints && this.inventory instanceof IHintSource && ((IHintSource)this.inventory).hasHints()) {
            this.ledgerManager.add(new HintLedger(this.ledgerManager, (IHintSource)this.inventory));
        }
        if (this.inventory instanceof TileForestry) {
            this.ledgerManager.add(new OwnerLedger(this.ledgerManager, (TileForestry)this.inventory));
        }
    }

    protected final void startPage() {
        this.line = 12;
        GL11.glPushMatrix();
    }

    protected final void startPage(int column0, int column1, int column2) {
        this.column0 = column0;
        this.column1 = column1;
        this.column2 = column2;
        this.startPage();
    }

    protected final int getLineY() {
        return this.line;
    }

    protected final void newLine() {
        this.line += 12;
    }

    protected final void newLineCompressed() {
        this.line += 10;
    }

    protected final void newLine(int lineHeight) {
        this.line += lineHeight;
    }

    protected final void endPage() {
        GL11.glPopMatrix();
    }

    protected final void drawRow(String text0, String text1, String text2, int colour0, int colour1, int colour2) {
        this.drawLine(text0, this.column0, colour0);
        this.drawLine(text1, this.column1, colour1);
        this.drawLine(text2, this.column2, colour2);
    }

    protected final void drawLine(String text, int x) {
        this.drawLine(text, x, this.fontColor.get("gui.screen"));
    }

    protected final void drawSplitLine(String text, int x, int maxWidth) {
        this.drawSplitLine(text, x, maxWidth, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width) {
        this.drawCenteredLine(text, x, width, this.fontColor.get("gui.screen"));
    }

    protected final void drawCenteredLine(String text, int x, int width, int color) {
        this.fontRendererObj.drawString(text, this.guiLeft + x + (width - this.fontRendererObj.getStringWidth(text)) / 2, this.guiTop + this.line, color);
    }

    protected final void drawLine(String text, int x, int color) {
        this.fontRendererObj.drawString(text, this.guiLeft + x, this.guiTop + this.line, color);
    }

    protected final void drawSplitLine(String text, int x, int maxWidth, int color) {
        this.fontRendererObj.drawSplitString(text, this.guiLeft + x, this.guiTop + this.line, maxWidth, color);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRendererObj.getStringWidth(string)) / 2;
    }

    protected void mouseClicked(int xPos, int yPos, int mouseButton) {
        super.mouseClicked(xPos, yPos, mouseButton);
        this.ledgerManager.handleMouseClicked(xPos, yPos, mouseButton);
        this.widgetManager.handleMouseClicked(xPos, yPos, mouseButton);
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        this.widgetManager.handleMouseRelease(mouseX, mouseY, eventType);
    }

    protected void mouseClickMove(int mouseX, int mouseY, int mouseButton, long time) {
        this.widgetManager.handleMouseMove(mouseX, mouseY, mouseButton, time);
        super.mouseClickMove(mouseX, mouseY, mouseButton, time);
    }

    protected Slot getSlotAtPosition(int par1, int par2) {
        for (int k = 0; k < this.inventorySlots.inventorySlots.size(); ++k) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(k);
            if (!this.isMouseOverSlot(slot, par1, par2)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot par1Slot, int par2, int par3) {
        return this.func_146978_c(par1Slot.xDisplayPosition, par1Slot.yDisplayPosition, 16, 16, par2, par3);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        int y;
        if (toolTips == null) {
            return;
        }
        if (toolTips.isEmpty()) {
            return;
        }
        int left = this.guiLeft;
        int top = this.guiTop;
        int length = 0;
        int height = 0;
        Iterator i$ = toolTips.iterator();
        while (i$.hasNext()) {
            ToolTipLine tip = (ToolTipLine)i$.next();
            y = this.fontRendererObj.getStringWidth(tip.toString());
            height += 10 + tip.getSpacing();
            if (y <= length) continue;
            length = y;
        }
        int x = mouseX - left + 12;
        y = mouseY - top - 12;
        this.zLevel = 300.0f;
        GuiForestry.itemRender.zLevel = 300.0f;
        Color backgroundColor = new Color(16, 0, 16, 240);
        int backgroundColorInt = backgroundColor.getRGB();
        this.drawGradientRect(x - 3, y - 4, x + length + 2, y - 3, backgroundColorInt, backgroundColorInt);
        this.drawGradientRect(x - 3, y + height + 1, x + length + 2, y + height + 2, backgroundColorInt, backgroundColorInt);
        this.drawGradientRect(x - 3, y - 3, x + length + 2, y + height + 1, backgroundColorInt, backgroundColorInt);
        this.drawGradientRect(x - 4, y - 3, x - 3, y + height + 1, backgroundColorInt, backgroundColorInt);
        this.drawGradientRect(x + length + 2, y - 3, x + length + 3, y + height + 1, backgroundColorInt, backgroundColorInt);
        Color borderColorTop = new Color(80, 0, 255, 80);
        int borderColorTopInt = borderColorTop.getRGB();
        Color borderColorBottom = new Color((borderColorTopInt & 0xFEFEFE) >> 1 | borderColorTopInt & 0xFF000000, true);
        int borderColorBottomInt = borderColorBottom.getRGB();
        this.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + height, borderColorTopInt, borderColorBottomInt);
        this.drawGradientRect(x + length + 1, y - 3 + 1, x + length + 2, y + height, borderColorTopInt, borderColorBottomInt);
        this.drawGradientRect(x - 3, y - 3, x + length + 2, y - 3 + 1, borderColorTopInt, borderColorTopInt);
        this.drawGradientRect(x - 3, y + height, x + length + 2, y + height + 1, borderColorBottomInt, borderColorBottomInt);
        boolean firstLine = true;
        Iterator i$2 = toolTips.iterator();
        while (i$2.hasNext()) {
            ToolTipLine tip = (ToolTipLine)i$2.next();
            String line = tip.toString();
            if (!firstLine) {
                line = EnumChatFormatting.GRAY + line;
            }
            this.fontRendererObj.drawStringWithShadow(line, x, y, -1);
            y += 10 + tip.getSpacing();
            firstLine = false;
        }
        this.zLevel = 0.0f;
        GuiForestry.itemRender.zLevel = 0.0f;
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GL11.glPushAttrib((int)8192);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ledgerManager.drawTooltips(mouseX, mouseY);
        InventoryPlayer playerInv = this.mc.thePlayer.inventory;
        if (playerInv.getItemStack() == null) {
            this.drawToolTips(this.widgetManager.widgets, mouseX, mouseY);
            this.drawToolTips(this.buttonList, mouseX, mouseY);
            this.drawToolTips(this.inventorySlots.inventorySlots, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void drawToolTips(Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip()) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX - this.guiLeft, mouseY - this.guiTop);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX, mouseY);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.textureFile);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        int left = this.guiLeft;
        int top = this.guiTop;
        GL11.glPushAttrib((int)8192);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawWidgets();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        this.bindTexture(this.textureFile);
    }

    protected void drawWidgets() {
        this.ledgerManager.drawLedgers();
        this.widgetManager.drawWidgets();
    }

    protected void bindTexture(ResourceLocation texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Proxies.common.bindTexture(texturePath);
    }

    public void setZLevel(float level) {
        this.zLevel = level;
    }

    public static RenderItem getItemRenderer() {
        return itemRender;
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        super.drawGradientRect(par1, par2, par3, par4, par5, par6);
    }

    public void drawItemStack(ItemStack stack, int xPos, int yPos) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.zLevel = 100.0f;
        GuiForestry.itemRender.zLevel = 100.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.getItem().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.fontRendererObj;
        }
        itemRender.renderItemAndEffectIntoGUI(font, this.mc.getTextureManager(), stack, xPos, yPos);
        itemRender.renderItemOverlayIntoGUI(font, this.mc.getTextureManager(), stack, xPos, yPos);
        this.zLevel = 0.0f;
        GuiForestry.itemRender.zLevel = 0.0f;
        RenderHelper.disableStandardItemLighting();
        GL11.glPopAttrib();
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (gui instanceof GuiForestry) {
            return ((GuiForestry)gui).ledgerManager.ledgerOverlaps(x, y, w, h);
        }
        return false;
    }

    protected class ItemStackWidget
    extends Widget {
        private final ItemStack itemStack;

        public ItemStackWidget(int xPos, int yPos, ItemStack itemStack) {
            super(GuiForestry.this.widgetManager, xPos, yPos);
            this.itemStack = itemStack;
        }

        @Override
        public void draw(int startX, int startY) {
            GuiForestry.this.drawItemStack(this.itemStack, this.xPos + startX, this.yPos + startY);
        }

        @Override
        public ToolTip getToolTip() {
            EntityPlayer player = Proxies.common.getPlayer();
            ToolTip tip = new ToolTip();
            if (this.itemStack != null) {
                tip.add(this.itemStack.getTooltip(player, false));
            }
            return tip;
        }
    }
}

