/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotCrafter;
import forestry.core.interfaces.IContainerCrafting;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.PacketGuiSelect;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.network.PacketWorktableMemoryUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerWorktable
extends ContainerTile<TileWorktable>
implements IContainerCrafting,
IGuiSelectable {
    private final InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    private long lastUpdate;

    public ContainerWorktable(EntityPlayer player, TileWorktable tile) {
        super(tile, player.inventory, 8, 136);
        InventoryAdapter craftingInventory = tile.getCraftingInventory();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlotToContainer(new Slot((IInventory)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.addSlotToContainer(new SlotCraftMatrix(this, (IInventory)craftingInventory, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.addSlotToContainer((Slot)new SlotCrafter(player, (IInventory)craftingInventory, tile, 9, 77, 38));
        this.updateMatrix();
        this.updateRecipe();
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.lastUpdate == ((TileWorktable)this.tile).getMemory().getLastUpdate()) {
            return;
        }
        this.lastUpdate = ((TileWorktable)this.tile).getMemory().getLastUpdate();
        PacketWorktableMemoryUpdate packet = new PacketWorktableMemoryUpdate((TileWorktable)this.tile);
        this.sendPacketToCrafters(packet);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.getSizeInventory()) {
            return;
        }
        ItemStack stack = iinventory.getStackInSlot(slot);
        if (!StackUtils.isIdenticalItem(stack, currentStack = this.craftMatrix.getStackInSlot(slot))) {
            this.craftMatrix.setInventorySlotContents(slot, stack);
            this.updateRecipe();
        }
    }

    private void updateMatrix() {
        for (int i = 0; i < this.craftMatrix.getSizeInventory(); ++i) {
            this.craftMatrix.setInventorySlotContents(i, ((TileWorktable)this.tile).getCraftingInventory().getStackInSlot(i));
        }
    }

    private void updateRecipe() {
        ((TileWorktable)this.tile).setRecipe(this.craftMatrix);
    }

    public static void clearRecipe() {
        ContainerWorktable.sendRecipeClick(0, 9);
    }

    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        PacketGuiSelect packet = new PacketGuiSelect(PacketId.GUI_SELECTION_CHANGE, mouseButton, recipeIndex);
        Proxies.net.sendToServer(packet);
    }

    @Override
    public void handleSelectionChange(EntityPlayer player, PacketGuiSelect packet) {
        if (packet.getPrimaryIndex() > 0) {
            ((TileWorktable)this.tile).getMemory().toggleLock(player.worldObj, packet.getSecondaryIndex());
        } else {
            ((TileWorktable)this.tile).chooseRecipe(packet.getSecondaryIndex());
            this.updateMatrix();
            this.updateRecipe();
        }
    }

    @Override
    public void setSelection(PacketGuiSelect packet) {
    }
}

